package com.elitescloud.cloudt.authorization.sdk.cas.task;

import com.elitescloud.cloudt.authorization.sdk.cas.provider.OAuth2ClientProvider;
import lombok.extern.log4j.Log4j2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 自动刷新客户端token.
 *
 * @author Kaiser（wang shao）
 * @date 2022/12/15
 */
public class AutoRefreshClientTokenTask implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(AutoRefreshClientTokenTask.class);
    private final OAuth2ClientProvider oAuth2ClientProvider;

    public AutoRefreshClientTokenTask(OAuth2ClientProvider oAuth2ClientProvider) {
        this.oAuth2ClientProvider = oAuth2ClientProvider;
    }

    @Override
    public void run() {
        var tokenResult = oAuth2ClientProvider.clientToken();
        if (Boolean.TRUE.equals(tokenResult.getSuccess())) {
            ClientTokenHolder.setToken(tokenResult.getData());
            LOG.info("客户端token刷新：{}", tokenResult.getData());
            return;
        }

        LOG.error("查询CAS客户端token失败：{}", tokenResult);
    }
}
