package com.elitescloud.cloudt.authorization.sdk.config;

import com.elitescloud.cloudt.authorization.sdk.cas.config.CasClientConfig;
import com.elitescloud.cloudt.authorization.sdk.resolver.UniqueRequestResolver;
import com.elitescloud.cloudt.authorization.sdk.resolver.impl.DefaultUniquestResolver;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.scheduling.annotation.EnableScheduling;

/**
 * SDK自动化配置.
 *
 * @author Kaiser（wang shao）
 * @date 2022/7/14
 */
@EnableConfigurationProperties(AuthorizationSdkProperties.class)
@EnableScheduling
@Import({CasClientConfig.class})
public class AuthorizationSdkAutoConfiguration {

    @Bean
    @ConditionalOnMissingBean
    public UniqueRequestResolver uniqueRequestResolver() {
        return new DefaultUniquestResolver("X-Cloudt-Unq");
    }

}
