package com.elitescloud.cloudt.authorization.sdk.config;

import com.elitescloud.cloudt.authorization.sdk.cas.config.CasClientProperties;
import com.elitescloud.cloudt.authorization.sdk.sso.common.SsoAccountType;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

import java.util.HashSet;
import java.util.Set;

/**
 * 属性配置.
 *
 * @author Kaiser（wang shao）
 * @date 2022/7/14
 */
@ConfigurationProperties(prefix = AuthorizationSdkProperties.CONFIG_PREFIX)
public class AuthorizationSdkProperties {
    public static final String CONFIG_PREFIX = "elitesland.authorization.sdk";

    /**
     * 授权服务器地址
     */
    private String authServer;

    /**
     * 是否是服务端
     */
    private Boolean server = false;
    /**
     * 单点登录相关配置
     */
    private final Sso sso = new Sso();
    /**
     * 统一身份认证客户端信息
     */
    @NestedConfigurationProperty
    private final CasClientProperties casClient = new CasClientProperties();

    public String getAuthServer() {
        return authServer;
    }

    public void setAuthServer(String authServer) {
        this.authServer = authServer;
    }

    public Boolean getServer() {
        return server;
    }

    public void setServer(Boolean server) {
        this.server = server;
    }

    public Sso getSso() {
        return sso;
    }

    public CasClientProperties getCasClient() {
        return casClient;
    }

    public static class Sso {
        /**
         * 是否启用
         */
        private Boolean enabled = false;
        /**
         * 账号类型
         */
        private SsoAccountType accountType = SsoAccountType.USER_NAME;
        /**
         * 客户端地址
         */
        private Set<String> clientAddress = new HashSet<>();
        /**
         * 认证路径
         */
        private String authorizeEndpoint = "/oauth/sso/authorize";
        /**
         * 取消认证
         */
        private String authorizeRevokeEndpoint = "/oauth/sso/revoke";
        /**
         * ticket写入的域名
         */
        private Set<String> cookieDomains = new HashSet<>(8);

        /**
         * 是否限制js无法获取cookie中的token
         */
        private Boolean cookieHttpOnly = false;

        /**
         * 是否限制cookie中的token只有https协议支持
         */
        private Boolean cookieSecure = false;

        public Boolean getEnabled() {
            return enabled;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public SsoAccountType getAccountType() {
            return accountType;
        }

        public void setAccountType(SsoAccountType accountType) {
            this.accountType = accountType;
        }

        public Set<String> getClientAddress() {
            return clientAddress;
        }

        public void setClientAddress(Set<String> clientAddress) {
            this.clientAddress = clientAddress;
        }

        public String getAuthorizeEndpoint() {
            return authorizeEndpoint;
        }

        public void setAuthorizeEndpoint(String authorizeEndpoint) {
            this.authorizeEndpoint = authorizeEndpoint;
        }

        public String getAuthorizeRevokeEndpoint() {
            return authorizeRevokeEndpoint;
        }

        public void setAuthorizeRevokeEndpoint(String authorizeRevokeEndpoint) {
            this.authorizeRevokeEndpoint = authorizeRevokeEndpoint;
        }

        public Set<String> getCookieDomains() {
            return cookieDomains;
        }

        public void setCookieDomains(Set<String> cookieDomains) {
            this.cookieDomains = cookieDomains;
        }

        public Boolean getCookieHttpOnly() {
            return cookieHttpOnly;
        }

        public void setCookieHttpOnly(Boolean cookieHttpOnly) {
            this.cookieHttpOnly = cookieHttpOnly;
        }

        public Boolean getCookieSecure() {
            return cookieSecure;
        }

        public void setCookieSecure(Boolean cookieSecure) {
            this.cookieSecure = cookieSecure;
        }
    }
}
