package com.elitescloud.cloudt.authorization.sdk.sso;

import com.elitescloud.cloudt.authorization.sdk.sso.common.TicketAuthentication;
import org.springframework.security.core.AuthenticationException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 单点登录服务提供者.
 *
 * @author Kaiser（wang shao）
 * @date 2022/7/14
 */
public interface SsoProvider {

    /**
     * 判断当前请求是否已认证
     * <p>
     * 是否已满足当前内部认证，如果满足，则不再需要进行sso认证
     *
     * @param request 请求
     * @return 是否已认证
     */
    default boolean isAuthenticated(HttpServletRequest request) {
        return false;
    }

    /**
     * ticket认证
     * <p>
     * 验证ticket，验证通过后生成token
     *
     * @param authentication 身份认证信息
     * @return token对象
     */
    TicketAuthentication authentication(HttpServletRequest request, HttpServletResponse response, TicketAuthentication authentication) throws AuthenticationException;

    /**
     * 删掉token
     * <p>
     * 用于注销
     *
     * @param request  request
     * @param response response
     * @param ticket   sso的ticket
     */
    void clearToken(HttpServletRequest request, HttpServletResponse response, String ticket);
}
