/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.sdk.cas.provider;

import com.elitescloud.cloudt.authorization.sdk.cas.model.thirdparty.WechatMiniProgramDTO;
import com.elitescloud.cloudt.authorization.sdk.cas.model.thirdparty.WechatServiceDTO;
import com.elitescloud.cloudt.authorization.sdk.cas.model.thirdparty.WechatSubscriptionDTO;
import com.elitescloud.cloudt.authorization.sdk.cas.provider.BaseTransferHelper;
import com.elitescloud.cloudt.authorization.sdk.model.Result;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.util.Assert;

public final class ThirdPartyAccountTransferHelper
extends BaseTransferHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ThirdPartyAccountTransferHelper.class);
    private static ThirdPartyAccountTransferHelper instance = null;

    private ThirdPartyAccountTransferHelper(String authServer) {
        super(authServer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ThirdPartyAccountTransferHelper getInstance(@NotBlank String authServer) {
        Class<ThirdPartyAccountTransferHelper> clazz = ThirdPartyAccountTransferHelper.class;
        synchronized (ThirdPartyAccountTransferHelper.class) {
            if (instance == null) {
                instance = new ThirdPartyAccountTransferHelper(authServer);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public Result<Long> upsertWechatService(@NotNull WechatServiceDTO dto) {
        Assert.notNull((Object)dto, (String)"\u5fae\u4fe1\u670d\u52a1\u53f7\u4fe1\u606f\u4e3a\u7a7a");
        LOG.info("\u540c\u6b65\u5fae\u4fe1\u670d\u52a1\u53f7\uff1a{}", (Object)dto.getAppId());
        return this.remoteExchange("/rpc/cloudt/authorization/third_party/wechat/upsertService", HttpMethod.POST, new HttpEntity((Object)dto), new ParameterizedTypeReference<Result<Long>>(){}, new Object[0]);
    }

    public Result<Long> upsertWechatMiniProgram(@NotNull WechatMiniProgramDTO dto) {
        Assert.notNull((Object)dto, (String)"\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u4fe1\u606f\u4e3a\u7a7a");
        LOG.info("\u540c\u6b65\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\uff1a{}", (Object)dto.getAppId());
        return this.remoteExchange("/rpc/cloudt/authorization/third_party/wechat/upsertMiniProgram", HttpMethod.POST, new HttpEntity((Object)dto), new ParameterizedTypeReference<Result<Long>>(){}, new Object[0]);
    }

    public Result<Long> upsertWechatSubscription(@NotNull WechatSubscriptionDTO dto) {
        Assert.notNull((Object)dto, (String)"\u5fae\u4fe1\u8ba2\u9605\u53f7\u4fe1\u606f\u4e3a\u7a7a");
        LOG.info("\u540c\u6b65\u5fae\u4fe1\u8ba2\u9605\u53f7\uff1a{}", (Object)dto.getAppId());
        return this.remoteExchange("/rpc/cloudt/authorization/third_party/wechat/upsertSubscription", HttpMethod.POST, new HttpEntity((Object)dto), new ParameterizedTypeReference<Result<Long>>(){}, new Object[0]);
    }

    public Result<Long> updateEnabled(long accountId, boolean enabled) {
        LOG.info("\u540c\u6b65\u7b2c\u4e09\u65b9\u8d26\u53f7\u72b6\u6001\uff1a{}, {}", (Object)accountId, (Object)enabled);
        return this.remoteExchange("/rpc/cloudt/authorization/third_party/update/enabled?accountId={accountId}&enabled={enabled}", HttpMethod.PATCH, null, new ParameterizedTypeReference<Result<Long>>(){}, accountId, enabled);
    }

    public Result<Long> delete(long accountId) {
        LOG.info("\u540c\u6b65\u5220\u9664\u7b2c\u4e09\u65b9\u8d26\u53f7\u72b6\u6001\uff1a{}", (Object)accountId);
        return this.remoteExchange("/rpc/cloudt/authorization/third_party/delete?accountId={accountId}", HttpMethod.DELETE, null, new ParameterizedTypeReference<Result<Long>>(){}, accountId);
    }
}

