/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.sdk.sso.configurer;

import com.elitescloud.cloudt.authorization.sdk.config.AuthorizationSdkProperties;
import com.elitescloud.cloudt.authorization.sdk.sso.SsoProvider;
import com.elitescloud.cloudt.authorization.sdk.sso.TicketResolver;
import com.elitescloud.cloudt.authorization.sdk.sso.configurer.filter.CloudtSsoFilter;
import com.elitescloud.cloudt.authorization.sdk.sso.impl.CookieTicketResolver;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;

public class SsoFilterConfigurer<H extends HttpSecurityBuilder<H>>
extends AbstractHttpConfigurer<SsoFilterConfigurer<H>, H> {
    private static final Logger log = LoggerFactory.getLogger(SsoFilterConfigurer.class);
    private final AuthorizationSdkProperties sdkProperties;
    private Class<? extends Filter> addFilterBeforeClass;
    private SsoProvider ssoProvider;
    private TicketResolver ticketResolver;
    private AuthenticationSuccessHandler authenticationSuccessHandler;
    private AuthenticationFailureHandler authenticationFailureHandler;

    public SsoFilterConfigurer(AuthorizationSdkProperties sdkProperties) {
        this.sdkProperties = sdkProperties;
    }

    public void init(H builder) throws Exception {
        if (this.ticketResolver == null) {
            this.ticketResolver = new CookieTicketResolver(this.sdkProperties);
        }
        super.init(builder);
    }

    public void configure(H builder) throws Exception {
        if (!this.sdkProperties.getSso().getEnabled().booleanValue()) {
            return;
        }
        CloudtSsoFilter filter = new CloudtSsoFilter(this.sdkProperties);
        if (this.ssoProvider == null) {
            log.warn("SsoProvider \u4e3a\u7a7a");
        }
        filter.setSsoProvider(this.ssoProvider);
        filter.setTicketResolver(this.ticketResolver);
        filter.setAuthenticationSuccessHandler(this.authenticationSuccessHandler);
        if (this.addFilterBeforeClass == null) {
            this.addFilterBeforeClass = AbstractPreAuthenticatedProcessingFilter.class;
        }
        builder.addFilterBefore((Filter)filter, this.addFilterBeforeClass);
        super.configure(builder);
    }

    public SsoFilterConfigurer<H> setAddFilterBeforeClass(Class<? extends Filter> clazz) {
        this.addFilterBeforeClass = clazz;
        return this;
    }

    public SsoFilterConfigurer<H> setSsoProvider(SsoProvider ssoProvider) {
        this.ssoProvider = ssoProvider;
        return this;
    }

    public SsoFilterConfigurer<H> setTicketResolver(TicketResolver ticketResolver) {
        this.ticketResolver = ticketResolver;
        return this;
    }

    public SsoFilterConfigurer<H> setAuthenticationSuccessHandler(AuthenticationSuccessHandler authenticationSuccessHandler) {
        this.authenticationSuccessHandler = authenticationSuccessHandler;
        return this;
    }

    public SsoFilterConfigurer<H> setAuthenticationFailureHandler(AuthenticationFailureHandler authenticationFailureHandler) {
        this.authenticationFailureHandler = authenticationFailureHandler;
        return this;
    }
}

