package com.elitescloud.cloudt.authorization.sdk.cas.provider;

import com.elitescloud.cloudt.authorization.sdk.cas.task.ClientTokenHolder;
import com.elitescloud.cloudt.authorization.sdk.util.RestTemplateFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.*;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.lang.NonNull;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

import java.io.IOException;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2/14/2023
 */
public abstract class BaseTransferHelper {
    private static final Logger LOG = LoggerFactory.getLogger(BaseTransferHelper.class);

    private final RestTemplate restTemplate;

    BaseTransferHelper(String authServer) {
        this.restTemplate = RestTemplateFactory.instance(builder -> builder.rootUri(authServer)
                .additionalInterceptors(new AuthorizationInterceptor())
        );
    }

    <T> T nullToDefault(T obj, T defaultObj) {
        return obj == null ? defaultObj : obj;
    }

    <T> T remoteExchange(String url, HttpMethod httpMethod, HttpEntity<?> httpEntity, ParameterizedTypeReference<T> responseType,
                                 Object... param) {
        ResponseEntity<T> response = null;
        try {
            response = restTemplate.exchange(url, httpMethod, httpEntity, responseType, param);
        } catch (RestClientException e) {
            LOG.error("认证授权服务器调用失败：", e);
            throw new RuntimeException("认证授权服务器异常", e);
        }

        if (response.getStatusCode() != HttpStatus.OK) {
            LOG.error("调用文件服务器接口失败：{}, {}", url, response);
            throw new RuntimeException("调用文件服务器接口失败");
        }
        LOG.info("接口{}调用成功", url);

        return response.getBody();
    }

    static class AuthorizationInterceptor implements ClientHttpRequestInterceptor {

        @NonNull
        @Override
        public ClientHttpResponse intercept(HttpRequest request, @NonNull byte[] body, @NonNull ClientHttpRequestExecution execution) throws IOException {
            HttpHeaders headers = request.getHeaders();
            var token = ClientTokenHolder.getToken();
            if (token == null) {
                throw new IllegalStateException("Token获取失败");
            }

            // 设置token
            headers.add(HttpHeaders.AUTHORIZATION, token.getTokenType() + " " + token.getAccessToken());
            return execution.execute(request, body);
        }
    }
}
