package com.elitescloud.cloudt.authorization.sdk.cas.provider;

/**
 * url常量.
 *
 * @author Kaiser（wang shao）
 * @date 2022/12/16
 */
interface CasUrlConstant {
    /**
     * 认证元数据
     */
    String URI_AUTHORIZATION_METADATA = "/.well-known/oauth-authorization-server";
    /**
     * OIDC元数据
     */
    String URI_OIDC_METADATA = "/.well-known/openid-configuration";

    /**
     * API接口前缀
     */
    String URI_API_PREFIX = "/rpc/cloudt/authorization";

    /**
     * 同步用户接口
     */
    String URI_USER_UPSERT = URI_API_PREFIX + "/user/upsertUser";
    /**
     * 批量同步用户接口
     */
    String URI_USER_UPSERT_BATCH = URI_API_PREFIX + "/user/upsertUser/batch?rollBackAllOnException={rollBackAllOnException}";
    /**
     * 修改用户状态接口
     */
    String URI_USER_UPDATE_ENABLED = URI_API_PREFIX + "/user/update/enabled?userId={userId}&enabled={enabled}";
    /**
     * 修改用户状态接口
     */
    String URI_USER_UPDATE_PWD = URI_API_PREFIX + "/user/update/pwd?userId={userId}&pd={pd}";
    /**
     * 更新账号过期时间
     */
    String URI_USER_UPDATE_EXPIRED_TIME = URI_API_PREFIX + "/user/update/expiredTime?userId={userId}&expiredTime={expiredTime}";
    /**
     * 更新账号的密码过期时间
     */
    String URI_USER_UPDATE_PWD_EXPIRED_TIME = URI_API_PREFIX + "/user/update/pwd/expiredTime?userId={userId}&expiredTime={expiredTime}";
    /**
     * 删除用户
     */
    String URI_USER_DELETE = URI_API_PREFIX + "/user/delete?userId={userId}";
    /**
     * 获取单个用户
     */
    String URI_USER_GET = URI_API_PREFIX + "/user/getUser?userId={userId}";
    /**
     * 获取单个用户
     */
    String URI_USER_GET_BY_USERNAME = URI_API_PREFIX + "/user/getUserByUsername?username={username}";
    /**
     * 获取多个用户
     */
    String URI_USER_LIST = URI_API_PREFIX + "/user/getUserList";
    /**
     * 根据账号获取ID
     */
    String URI_USER_ID_BY_USERNAME = URI_API_PREFIX + "/user/getUserIdByUsername";
    /**
     * 根据手机号获取ID
     */
    String URI_USER_ID_BY_MOBILE = URI_API_PREFIX + "/user/getUserIdByMobile";
    /**
     * 根据邮箱获取ID
     */
    String URI_USER_ID_BY_EMAIL = URI_API_PREFIX + "/user/getUserIdByEmail";

    /**
     * 同步第三方账号-微信服务号
     */
    String URI_THIRD_PARTY_UPSERT_WECHAT_SERVICE = URI_API_PREFIX + "/third_party/wechat/upsertService";
    /**
     * 同步第三方账号-微信小程序
     */
    String URI_THIRD_PARTY_UPSERT_WECHAT_MINI = URI_API_PREFIX + "/third_party/wechat/upsertMiniProgram";
    /**
     * 同步第三方账号-微信订阅号
     */
    String URI_THIRD_PARTY_UPSERT_WECHAT_SUBSCRIPTION = URI_API_PREFIX + "/third_party/wechat/upsertSubscription";
    /**
     * 同步第三方账号的启用状态
     */
    String URI_THIRD_PARTY_UPDATE_ENABLED = URI_API_PREFIX + "/third_party/update/enabled?accountId={accountId}&enabled={enabled}";
    /**
     * 删除第三方账号
     */
    String URI_THIRD_PARTY_DELETE = URI_API_PREFIX + "/third_party/delete?accountId={accountId}";
}
