/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.sdk.sso.impl;

import com.elitescloud.cloudt.authorization.sdk.config.AuthorizationSdkProperties;
import com.elitescloud.cloudt.authorization.sdk.sso.TicketResolver;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class CookieTicketResolver
implements TicketResolver {
    private static final Logger logger = LoggerFactory.getLogger(CookieTicketResolver.class);
    private final AuthorizationSdkProperties sdkProperties;

    public CookieTicketResolver(AuthorizationSdkProperties sdkProperties) {
        this.sdkProperties = sdkProperties;
    }

    @Override
    public String obtain(HttpServletRequest request) {
        String ticket = request.getParameter("ticket");
        if (StringUtils.hasText((String)ticket)) {
            return ticket;
        }
        ticket = request.getHeader("X-Auth-ticket");
        if (StringUtils.hasText((String)ticket)) {
            return ticket;
        }
        Cookie[] cookies = request.getCookies();
        if (cookies == null || cookies.length == 0) {
            return null;
        }
        for (Cookie cookie : cookies) {
            if (!"cloudt_ticket".equals(cookie.getName())) continue;
            logger.info("\u83b7\u53d6\u5230ticket\uff1a{}", (Object)cookie.getValue());
            return cookie.getValue();
        }
        return null;
    }

    @Override
    public void save(HttpServletRequest request, HttpServletResponse response, String ticket) {
        AuthorizationSdkProperties.Sso sso = this.sdkProperties.getSso();
        this.writeToCookie(ticket, sso.getCookieDomains(), sso.getCookieHttpOnly(), sso.getCookieSecure(), response);
    }

    @Override
    public void clear(HttpServletRequest request, HttpServletResponse response) {
        this.clearCookie(this.sdkProperties.getSso().getCookieDomains(), response);
    }

    private void writeToCookie(String ticket, Set<String> domains, boolean httpOnly, boolean secure, HttpServletResponse response) {
        if (CollectionUtils.isEmpty(domains)) {
            logger.error("sso ticket\u5199\u5165cookie\u5931\u8d25\uff0c\u57df\u540d\u672a\u914d\u7f6e");
            return;
        }
        List cookies = domains.stream().map(t -> {
            Cookie cookie = new Cookie("cloudt_ticket", ticket);
            cookie.setDomain(t);
            cookie.setPath("/");
            cookie.setHttpOnly(httpOnly);
            cookie.setSecure(secure);
            return cookie;
        }).collect(Collectors.toList());
        for (Cookie cookie : cookies) {
            response.addCookie(cookie);
        }
    }

    private void clearCookie(Set<String> domains, HttpServletResponse response) {
        if (CollectionUtils.isEmpty(domains)) {
            logger.error("sso ticket\u6e05\u7406cookie\u5931\u8d25\uff0c\u57df\u540d\u672a\u914d\u7f6e");
            return;
        }
        List cookies = domains.stream().map(t -> {
            Cookie cookie = new Cookie("cloudt_ticket", null);
            cookie.setDomain(t);
            cookie.setPath("/");
            cookie.setMaxAge(0);
            return cookie;
        }).collect(Collectors.toList());
        for (Cookie cookie : cookies) {
            response.addCookie(cookie);
        }
    }
}

