/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.client;

import com.elitescloud.boot.auth.client.CloudtAuthProperties;
import com.elitescloud.boot.auth.client.common.AuthClientException;
import com.elitescloud.boot.auth.client.config.support.ClientAuthorizationInterceptor;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import javax.net.ssl.HostnameVerifier;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.converter.xml.MappingJackson2XmlHttpMessageConverter;
import org.springframework.util.Assert;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.DefaultUriBuilderFactory;
import org.springframework.web.util.UriTemplateHandler;

public class CloudtAuthClient
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(CloudtAuthClient.class);
    private final CloudtAuthProperties properties;
    private final RestTemplate restTemplate;

    public CloudtAuthClient(CloudtAuthProperties properties) {
        this.properties = properties;
        this.restTemplate = this.restTemplateInstance();
    }

    public <T> T exchange(@NotBlank String url, @NotNull HttpMethod method, Object requestBody, @NotNull ParameterizedTypeReference<T> responseType, Object ... uriParameters) {
        ResponseEntity response = null;
        try {
            response = this.restTemplate.exchange(url, method, new HttpEntity(requestBody, null), responseType, uriParameters);
        }
        catch (RestClientException e) {
            LOG.error(url + "\u8c03\u7528\u5931\u8d25\uff1a", (Throwable)e);
            throw new RuntimeException("\u8fdc\u7a0b\u670d\u52a1\u5668\u5f02\u5e38", e);
        }
        if (response.getStatusCode() != HttpStatus.OK) {
            LOG.error("\u8c03\u7528\u63a5\u53e3\u5931\u8d25\uff1a{}, {}", (Object)url, (Object)response);
            throw new AuthClientException("\u8c03\u7528\u8fdc\u7a0b\u63a5\u53e3\u5931\u8d25");
        }
        LOG.info("\u63a5\u53e3{}\u8c03\u7528\u6210\u529f", (Object)url);
        return (T)response.getBody();
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.properties, (String)"\u8ba4\u8bc1\u914d\u7f6e\u4e3a\u7a7a");
        Assert.notNull((Object)this.properties.getServerAddr(), (String)"\u670d\u52a1\u7aef\u5730\u5740\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4\u5df2\u914d\u7f6eelitesland.auth.client.server-addr");
        Assert.notNull((Object)this.properties.getClientId(), (String)"\u5ba2\u6237\u7aefID\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4\u5df2\u914d\u7f6eelitesland.auth.client.client-id");
        Assert.notNull((Object)this.properties.getClientSecret(), (String)"\u5ba2\u6237\u7aef\u5bc6\u7801\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4\u5df2\u914d\u7f6eelitesland.auth.client.client-secret");
    }

    private RestTemplate restTemplateInstance() {
        return new RestTemplateBuilder(new RestTemplateCustomizer[0]).rootUri(this.properties.getServerAddr()).requestFactory(this::getClientHttpRequestFactory).uriTemplateHandler(this.uriTemplateHandler()).customizers(new RestTemplateCustomizer[]{this.restTemplateCustomizer()}).additionalInterceptors(new ClientHttpRequestInterceptor[]{new ClientAuthorizationInterceptor()}).build();
    }

    private ClientHttpRequestFactory getClientHttpRequestFactory() {
        SSLConnectionSocketFactory sslConnectionSocketFactory = null;
        try {
            SSLContextBuilder sslContextBuilder = new SSLContextBuilder();
            sslContextBuilder.loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy());
            sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContextBuilder.build(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        }
        catch (Exception e) {
            throw new IllegalStateException("\u5ba2\u6237\u7aef\u521d\u59cb\u5316\u5931\u8d25", e);
        }
        HttpClientBuilder httpClientBuilder = HttpClients.custom();
        httpClientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionSocketFactory);
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory();
        requestFactory.setHttpClient((HttpClient)httpClientBuilder.build());
        requestFactory.setConnectTimeout((int)Duration.ofSeconds(10L).toMillis());
        requestFactory.setReadTimeout((int)Duration.ofSeconds(60L).toMillis());
        return requestFactory;
    }

    private UriTemplateHandler uriTemplateHandler() {
        DefaultUriBuilderFactory handler = new DefaultUriBuilderFactory();
        handler.setEncodingMode(DefaultUriBuilderFactory.EncodingMode.TEMPLATE_AND_VALUES);
        return handler;
    }

    private RestTemplateCustomizer restTemplateCustomizer() {
        ObjectMapper objectMapper = this.objectMapperInstance();
        return template -> {
            MappingJackson2HttpMessageConverter jsonConvert = null;
            int xmlConvertIndex = -1;
            int index = 0;
            for (HttpMessageConverter convert : template.getMessageConverters()) {
                if (convert instanceof MappingJackson2XmlHttpMessageConverter) {
                    xmlConvertIndex = index;
                }
                if (convert instanceof MappingJackson2HttpMessageConverter) {
                    jsonConvert = (MappingJackson2HttpMessageConverter)convert;
                }
                ++index;
            }
            if (jsonConvert == null) {
                jsonConvert = new MappingJackson2HttpMessageConverter(objectMapper);
                template.getMessageConverters().add(jsonConvert);
            } else {
                jsonConvert.setObjectMapper(objectMapper);
            }
            if (xmlConvertIndex >= 0) {
                template.getMessageConverters().remove(jsonConvert);
                template.getMessageConverters().add(xmlConvertIndex - 1, jsonConvert);
            }
        };
    }

    private ObjectMapper objectMapperInstance() {
        return Jackson2ObjectMapperBuilder.json().serializerByType(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"))).serializerByType(LocalDate.class, (JsonSerializer)new LocalDateSerializer(DateTimeFormatter.ofPattern("yyyy-MM-dd"))).deserializerByType(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"))).deserializerByType(LocalDate.class, (JsonDeserializer)new LocalDateDeserializer(DateTimeFormatter.ofPattern("yyyy-MM-dd"))).simpleDateFormat("yyyy-MM-dd HH:mm:ss").failOnUnknownProperties(false).failOnEmptyBeans(false).build();
    }
}

