package com.elitescloud.boot.auth.cas.common;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 证件类型.
 *
 * @author Kaiser（wang shao）
 * @date 2022/9/6
 */
public enum IdType {

    /**
     * 身份证
     */
    ID_CARD("身份证"),
    /**
     * 军官证
     */
    OFFICER_PASS("军官证"),
    PASSPORT("护照"),
    ;

    private final String description;

    IdType(String description) {
        this.description = description;
    }

    public String getDescription() {
        return description;
    }

    private static final Map<String, IdType> all = Arrays.stream(IdType.values())
            .collect(Collectors.toMap(Enum::name, t -> t, (t1, t2) -> t1));

    public static IdType parse(String val) {
        return all.get(val);
    }
}
