package com.elitescloud.boot.auth.cas.common;

import org.springframework.util.StringUtils;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 密码修改类型.
 *
 * @author Kaiser（wang shao）
 * @date 2023/11/7
 */
public enum PwdRecordTypeEnum {
    /**
     * 初始化
     */
    INIT("初始化"),
    UPDATE("修改密码"),
    RESET("重置密码"),
    RETRIEVE("找回密码"),
    UPDATE_SYNC("同步修改"),
    ;

    private final String description;

    PwdRecordTypeEnum(String description) {
        this.description = description;
    }

    public String getDescription() {
        return description;
    }

    private static final Map<String, PwdRecordTypeEnum> ALL = Arrays.stream(PwdRecordTypeEnum.values())
            .collect(Collectors.toMap(PwdRecordTypeEnum::name, t -> t, (t1, t2) -> t1));

    /**
     * 解析修改类型
     *
     * @param value 待解析字符串
     * @return 类型
     */
    public static PwdRecordTypeEnum parse(String value) {
        if (!StringUtils.hasText(value)) {
            return null;
        }
        return ALL.get(value);
    }
}
