package com.elitescloud.boot.auth.cas.model;

import com.elitescloud.boot.auth.cas.common.IdType;

import java.io.Serializable;
import java.util.Set;

/**
 * 用户查询参数.
 *
 * @author Kaiser（wang shao）
 * @date 2023/10/25
 */
public class AuthUserQueryDTO implements Serializable {
    private static final long serialVersionUID = -4124023694075752728L;

    /**
     * 身份类型，登录区分
     */
    private String identityType;

    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 根据用户ID查询
     */
    private Set<Long> userIds;

    /**
     * 根据登录号查询
     */
    private String username;

    /**
     * 根据登录号查询
     */
    private Set<String> usernames;

    /**
     * 根据手机号查询
     */
    private String mobile;

    /**
     * 根据手机号查询
     */
    private Set<String> mobiles;

    /**
     * 根据邮箱查询
     */
    private String email;

    /**
     * 根据邮箱查询
     */
    private Set<String> emails;

    /**
     * 证件类型
     * {@link IdType}
     */
    private IdType idType;

    /**
     * 证件号码
     */
    private String idNum;

    /**
     * 证件号码
     */
    private Set<String> idNums;

    public String getIdentityType() {
        return identityType;
    }

    public void setIdentityType(String identityType) {
        this.identityType = identityType;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Set<Long> getUserIds() {
        return userIds;
    }

    public void setUserIds(Set<Long> userIds) {
        this.userIds = userIds;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public Set<String> getUsernames() {
        return usernames;
    }

    public void setUsernames(Set<String> usernames) {
        this.usernames = usernames;
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public Set<String> getMobiles() {
        return mobiles;
    }

    public void setMobiles(Set<String> mobiles) {
        this.mobiles = mobiles;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Set<String> getEmails() {
        return emails;
    }

    public void setEmails(Set<String> emails) {
        this.emails = emails;
    }

    public IdType getIdType() {
        return idType;
    }

    public void setIdType(IdType idType) {
        this.idType = idType;
    }

    public String getIdNum() {
        return idNum;
    }

    public void setIdNum(String idNum) {
        this.idNum = idNum;
    }

    public Set<String> getIdNums() {
        return idNums;
    }

    public void setIdNums(Set<String> idNums) {
        this.idNums = idNums;
    }
}
