package com.elitescloud.boot.auth.cas.model;

import org.springframework.web.util.UriComponentsBuilder;

import java.io.Serializable;
import java.util.Optional;

/**
 * 认证信息.
 *
 * @author Kaiser（wang shao）
 * @date 2022/12/11
 */
public class AuthorizeDTO implements Serializable {
    private static final long serialVersionUID = -1959826592986980733L;

    /**
     * 认证地址
     */
    private String authorizeEndpoint;
    /**
     * 客户端ID
     */
    private String clientId;
    /**
     * 响应类型
     */
    private String responseType;

    /**
     * 授权范围
     */
    private String scope;
    /**
     * 重定向路径
     */
    private String redirectUri;
    /**
     * 验证码
     */
    private String codeVerifier;
    /**
     * 加密方式
     */
    private String codeChallengeMethod;
    /**
     * 加密值
     */
    private String codeChallenge;
    /**
     * 客户端自定义参数
     */
    private String state;
    /**
     * 认证服务地址
     */
    private String authServer;
    /**
     * 注销URL
     */
    private String logoutUrl;

    public String getAuthorizeEndpoint() {
        return authorizeEndpoint;
    }

    public void setAuthorizeEndpoint(String authorizeEndpoint) {
        this.authorizeEndpoint = authorizeEndpoint;
    }

    public String getClientId() {
        return clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getResponseType() {
        return responseType;
    }

    public void setResponseType(String responseType) {
        this.responseType = responseType;
    }

    public String getScope() {
        return scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getRedirectUri() {
        return redirectUri;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public String getCodeVerifier() {
        return codeVerifier;
    }

    public void setCodeVerifier(String codeVerifier) {
        this.codeVerifier = codeVerifier;
    }

    public String getCodeChallengeMethod() {
        return codeChallengeMethod;
    }

    public void setCodeChallengeMethod(String codeChallengeMethod) {
        this.codeChallengeMethod = codeChallengeMethod;
    }

    public String getCodeChallenge() {
        return codeChallenge;
    }

    public void setCodeChallenge(String codeChallenge) {
        this.codeChallenge = codeChallenge;
    }

    public String getAuthServer() {
        return authServer;
    }

    public void setAuthServer(String authServer) {
        this.authServer = authServer;
    }

    public String getState() {
        return state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getLogoutUrl() {
        return logoutUrl;
    }

    public void setLogoutUrl(String logoutUrl) {
        this.logoutUrl = logoutUrl;
    }

    public String getUrl() {
        return UriComponentsBuilder.fromUriString(getAuthorizeEndpoint())
                .queryParamIfPresent("client_id", Optional.ofNullable(getClientId()))
                .queryParamIfPresent("response_type", Optional.ofNullable(getResponseType()))
                .queryParamIfPresent("scope", Optional.ofNullable(getScope()))
                .queryParamIfPresent("redirect_uri", Optional.ofNullable(getRedirectUri()))
                .queryParamIfPresent("code_challenge_method", Optional.ofNullable(getCodeChallengeMethod()))
                .queryParamIfPresent("code_challenge", Optional.ofNullable(getCodeChallenge()))
                .queryParamIfPresent("state", Optional.ofNullable(getState()))
                .toUriString();
    }
}
