package com.elitescloud.boot.auth.cas.model;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 登录用户详细信息的扩展信息.
 *
 * @author Kaiser（wang shao）
 * @date 2023/11/30
 */
public class UserDetailExtendDTO implements Serializable {
    private static final long serialVersionUID = 5057838512562079309L;

    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 密码是否需要重置
     */
    private Boolean needReset;

    /**
     * 密码过期时间
     */
    private LocalDateTime pwdExpiredTime;

    /**
     * 账号过期时间
     */
    private LocalDateTime expiredTime;

    /**
     * 是否限制只能在线一个
     */
    private Boolean onlineLimitOne;

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Boolean getNeedReset() {
        return needReset;
    }

    public void setNeedReset(Boolean needReset) {
        this.needReset = needReset;
    }

    public LocalDateTime getPwdExpiredTime() {
        return pwdExpiredTime;
    }

    public void setPwdExpiredTime(LocalDateTime pwdExpiredTime) {
        this.pwdExpiredTime = pwdExpiredTime;
    }

    public LocalDateTime getExpiredTime() {
        return expiredTime;
    }

    public void setExpiredTime(LocalDateTime expiredTime) {
        this.expiredTime = expiredTime;
    }

    public Boolean getOnlineLimitOne() {
        return onlineLimitOne;
    }

    public void setOnlineLimitOne(Boolean onlineLimitOne) {
        this.onlineLimitOne = onlineLimitOne;
    }
}
