package com.elitescloud.boot.auth.cas.provider;

import com.elitescloud.boot.auth.cas.model.AuthorizeDTO;
import com.elitescloud.boot.auth.cas.model.OAuth2UserInfoDTO;
import com.elitescloud.boot.auth.model.OAuthToken;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * OAuth2Client操作.
 *
 * @author Kaiser（wang shao）
 * @date 2023/10/19
 */
public interface OAuth2ClientTemplate {

    /**
     * 生成认证URL
     *
     * @param request  request
     * @param response response
     * @return 认证url
     */
    AuthorizeDTO generateAuthorizeInfo(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response);

    /**
     * 授权码换token
     *
     * @param request  request
     * @param response response
     * @param code     授权码
     * @return token信息
     */
    OAuthToken code2Token(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotBlank String code);

    /**
     * 置换用户信息
     *
     * @param request   request
     * @param tokenType token类型
     * @param token     token
     * @return 用户信息
     */
    OAuth2UserInfoDTO getUserInfo(@NotNull HttpServletRequest request, @NotBlank String tokenType, @NotBlank String token);

    /**
     * 生成客户端token
     *
     * @return token
     */
    OAuthToken clientToken();

    /**
     * 撤销token
     *
     * @param token token
     * @return 是否成功
     */
    Boolean revokeToken(@NotBlank String token);
}
