package com.elitescloud.boot.auth.cas.provider;

import com.elitescloud.boot.auth.cas.common.PwdStrategyTypeEnum;
import com.elitescloud.boot.auth.cas.model.UserDetailExtendDTO;
import com.elitescloud.boot.auth.cas.model.pwd.AuthPwdStrategyConfigDTO;
import com.elitescloud.boot.auth.cas.model.pwd.AuthPwdStrategyDTO;
import com.elitescloud.boot.auth.cas.model.pwd.AuthPwdStrategySaveDTO;
import com.elitescloud.boot.auth.model.Result;
import com.fasterxml.jackson.core.type.TypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;

/**
 * 密码策略助手.
 *
 * @author Kaiser（wang shao）
 * @date 2023/11/29
 */
public class PwdStrategyTransferHelper extends BaseTransferHelper {
    private static PwdStrategyTransferHelper instance = null;

    public PwdStrategyTransferHelper(String authServer) {
        super(authServer);
    }

    public static PwdStrategyTransferHelper getInstance(@NotBlank String authServer) {
        if (instance == null) {
            synchronized (PwdStrategyTransferHelper.class) {
                if (instance == null) {
                    instance = new PwdStrategyTransferHelper(authServer);
                }
            }
        }
        return instance;
    }

    /**
     * 获取配置的策略
     *
     * @return 策略列表
     */
    public Result<AuthPwdStrategyConfigDTO> get() {
        return remoteExchange(CasUrlConstant.URI_PWD_STRATEGY_GET, HttpMethod.GET, null,
                new TypeReference<>() {
                });
    }

    /**
     * 获取默认的策略
     *
     * @return 策略列表
     */
    public Result<AuthPwdStrategyConfigDTO> getDefault() {
        return remoteExchange(CasUrlConstant.URI_PWD_STRATEGY_GET_DEFAULT, HttpMethod.GET, null,
                new TypeReference<>() {
                });
    }

    /**
     * 获取配置的策略
     *
     * @return 策略列表
     */
    public Result<Boolean> save(List<AuthPwdStrategySaveDTO> saveDTOList) {
        return remoteExchange(CasUrlConstant.URI_PWD_STRATEGY_SAVE, HttpMethod.POST, new HttpEntity<>(saveDTOList),
                new TypeReference<>() {
                });
    }

    /**
     * 根据类型获取策略列表
     *
     * @param type 策略类型
     * @return 策略列表
     */
    public Result<ArrayList<AuthPwdStrategyDTO>> listByType(PwdStrategyTypeEnum type) {
        return remoteExchange(CasUrlConstant.URI_PWD_STRATEGY_LIST_BY_TYPE, HttpMethod.GET, null,
                new TypeReference<>() {
                }, type == null ? "" : type.name());
    }

    /**
     * 验证密码
     *
     * @param password 待验证密码
     * @return 验证结果
     */
    public Result<String> verifyPassword(Long userId, String username, @NotBlank String password) {
        Assert.hasText(password, "密码不能为空");
        return remoteExchange(CasUrlConstant.URI_PWD_STRATEGY_VERIFY, HttpMethod.GET, null,
                new TypeReference<>() {
                }, userId == null ? "" : userId, StringUtils.hasText(username) ? username : "", password);
    }

    /**
     * 验证密码
     *
     * @param userId 用户ID
     * @return 获取用户登录扩展信息
     */
    public Result<UserDetailExtendDTO> getLoginUserDetailExtend(@NotNull Long userId) {
        Assert.notNull(userId, "用户ID不能为空");
        return remoteExchange(CasUrlConstant.URI_PWD_USER_DETAIL_EXTEND, HttpMethod.GET, null,
                new TypeReference<>() {
                }, userId);
    }
}
