package com.elitescloud.boot.auth.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import org.springframework.security.oauth2.core.endpoint.OAuth2ParameterNames;
import org.springframework.security.oauth2.core.oidc.endpoint.OidcParameterNames;

import java.io.Serializable;
import java.util.Set;

/**
 * token信息.
 *
 * @author Kaiser（wang shao）
 * @date 2021/10/23
 */
@Data
@JsonInclude(value = JsonInclude.Include.NON_NULL)
public class OAuthToken implements Serializable {
    private static final long serialVersionUID = 3464052327791924781L;

    /**
     * AccessToken
     */
    @JsonProperty(value = OAuth2ParameterNames.ACCESS_TOKEN)
    private String accessToken;

    /**
     * 有效期，单位秒
     */
    @JsonProperty(value = OAuth2ParameterNames.EXPIRES_IN)
    private Long expiresIn;

    /**
     * 授权范围
     */
    @JsonProperty(value = OAuth2ParameterNames.SCOPE)
    private Set<String> scope;

    /**
     * token类型
     */
    @JsonProperty(value = OAuth2ParameterNames.TOKEN_TYPE)
    private String tokenType;

    /**
     * 刷新token
     */
    @JsonProperty(value = OAuth2ParameterNames.REFRESH_TOKEN)
    private String refreshToken;

    /**
     * idToken
     */
    @JsonProperty(value = OidcParameterNames.ID_TOKEN)
    private String idToken;
}
