package com.elitescloud.boot.auth.util;

import com.elitescloud.boot.auth.cas.common.IdType;
import com.elitescloud.boot.auth.cas.model.AuthUserDTO;
import com.elitescloud.cloudt.authorization.sdk.model.Result;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 版本兼容工具类.
 *
 * @author Kaiser（wang shao）
 * @date 2023/11/30
 */
@SuppressWarnings({"deprecation", "removal"})
public class AuthCompatibilityUtil {
    private AuthCompatibilityUtil() {
    }

    /**
     * 转换结果
     *
     * @param result
     * @param <T>
     * @return
     */
    public static <T extends Serializable> Result<T> convert(com.elitescloud.boot.auth.model.Result<T> result) {
        if (result == null) {
            return null;
        }
        var res = new Result<T>();
        res.setMsg(result.getMsg());
        res.setSuccess(result.getSuccess());
        res.setData(result.getData());
        res.setTime(result.getTime());
        return res;
    }

    /**
     * 转换结果
     *
     * @param result
     * @param mapping
     * @param <T>
     * @param <R>
     * @return
     */
    public static <T extends Serializable, R extends Serializable> Result<R> convert(com.elitescloud.boot.auth.model.Result<T> result, Function<T, R> mapping) {
        if (result == null) {
            return null;
        }
        var res = new Result<R>();
        res.setMsg(result.getMsg());
        res.setSuccess(result.getSuccess());
        res.setData(mapping.apply(result.getData()));
        res.setTime(result.getTime());
        return res;
    }

    /**
     * 转换用户
     *
     * @param authUserDtoList
     * @return
     */
    public static List<AuthUserDTO> convert(List<com.elitescloud.cloudt.authorization.sdk.cas.model.AuthUserDTO> authUserDtoList) {
        if (authUserDtoList == null) {
            return null;
        }
        if (authUserDtoList.isEmpty()) {
            return Collections.emptyList();
        }

        return authUserDtoList.stream().map(AuthCompatibilityUtil::convert).collect(Collectors.toList());
    }

    /**
     * 转换用户
     *
     * @param authUserDTO
     * @return
     */
    public static com.elitescloud.boot.auth.cas.model.AuthUserDTO convert(com.elitescloud.cloudt.authorization.sdk.cas.model.AuthUserDTO authUserDTO) {
        if (authUserDTO == null) {
            return null;
        }
        com.elitescloud.boot.auth.cas.model.AuthUserDTO dto = new com.elitescloud.boot.auth.cas.model.AuthUserDTO();
        dto.setId(authUserDTO.getId());
        dto.setUsername(authUserDTO.getUsername());
        dto.setIdentityType(authUserDTO.getIdentityType());
        dto.setUserType(authUserDTO.getUserType());
        dto.setPassword(authUserDTO.getPassword());
        dto.setLastName(authUserDTO.getLastName());
        dto.setFirstName(authUserDTO.getFirstName());
        dto.setGender(authUserDTO.getGender());
        dto.setPasswordExpiredTime(authUserDTO.getPasswordExpiredTime());
        dto.setExpiredTime(authUserDTO.getExpiredTime());
        dto.setNickname(authUserDTO.getNickname());
        dto.setEnabled(authUserDTO.getEnabled());
        dto.setMobile(authUserDTO.getMobile());
        dto.setEmail(authUserDTO.getEmail());
        if (authUserDTO.getIdType() != null) {
            dto.setIdType(authUserDTO.getIdType());
        } else if (authUserDTO.getIdTypes() != null) {
            dto.setIdType(IdType.parse(authUserDTO.getIdTypes().name()));
        }
        dto.setIdNum(authUserDTO.getIdNum());
        dto.setRemark(authUserDTO.getRemark());
        dto.setUpdaterInfo(authUserDTO.getUpdaterInfo());

        return dto;
    }

    /**
     * 转换用户
     *
     * @param dtoList
     * @return
     */
    public static ArrayList<com.elitescloud.cloudt.authorization.sdk.cas.model.AuthUserDTO> convert(ArrayList<com.elitescloud.boot.auth.cas.model.AuthUserDTO> dtoList) {
        if (dtoList == null) {
            return null;
        }
        if (dtoList.isEmpty()) {
            return new ArrayList<>(0);
        }

        ArrayList<com.elitescloud.cloudt.authorization.sdk.cas.model.AuthUserDTO> result = new ArrayList<>(dtoList.size());
        for (com.elitescloud.boot.auth.cas.model.AuthUserDTO dto : dtoList) {
            result.add(AuthCompatibilityUtil.convert(dto));
        }
        return result;
    }

    /**
     * 转换用户
     *
     * @param dto
     * @return
     */
    public static com.elitescloud.cloudt.authorization.sdk.cas.model.AuthUserDTO convert(com.elitescloud.boot.auth.cas.model.AuthUserDTO dto) {
        if (dto == null) {
            return null;
        }
        com.elitescloud.cloudt.authorization.sdk.cas.model.AuthUserDTO user = new com.elitescloud.cloudt.authorization.sdk.cas.model.AuthUserDTO();
        if (dto.getIdType() != null) {
            user.setIdTypes(com.elitescloud.cloudt.authorization.sdk.cas.common.IdType.parse(dto.getIdType().name()));
        }
        user.setId(dto.getId());
        user.setUsername(dto.getUsername());
        user.setIdentityType(dto.getIdentityType());
        user.setUserType(dto.getUserType());
        user.setPassword(dto.getPassword());
        user.setLastName(dto.getLastName());
        user.setFirstName(dto.getFirstName());
        user.setGender(dto.getGender());
        user.setPasswordExpiredTime(dto.getPasswordExpiredTime());
        user.setExpiredTime(dto.getExpiredTime());
        user.setNickname(dto.getNickname());
        user.setEnabled(dto.getEnabled());
        user.setMobile(dto.getMobile());
        user.setEmail(dto.getEmail());
        user.setIdType(dto.getIdType());
        user.setIdNum(dto.getIdNum());
        user.setRemark(dto.getRemark());
        user.setUpdaterInfo(dto.getUpdaterInfo());

        return user;
    }
}
