package com.elitescloud.cloudt.authorization.sdk.cas.provider;

import com.elitescloud.boot.auth.cas.model.pwd.AuthPwdUpdateDTO;
import com.elitescloud.boot.auth.cas.model.AuthUserQueryDTO;
import com.elitescloud.boot.auth.util.AuthCompatibilityUtil;
import com.elitescloud.cloudt.authorization.sdk.cas.model.AuthUserDTO;
import com.elitescloud.cloudt.authorization.sdk.model.Result;

import javax.validation.constraints.NotBlank;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * 用户传输服务.
 *
 * @author Kaiser（wang shao）
 * @date 2022/12/16
 * @deprecated 请使用 {@link com.elitescloud.boot.auth.cas.provider.UserTransferHelper}
 */
@SuppressWarnings({"deprecation", "removal"})
@Deprecated(forRemoval = true, since = "3.2.0")
public final class UserTransferHelper {

    private static UserTransferHelper transferHelper = null;
    private com.elitescloud.boot.auth.cas.provider.UserTransferHelper proxy;

    private UserTransferHelper(String authServer) {
        proxy = com.elitescloud.boot.auth.cas.provider.UserTransferHelper.getInstance(authServer);
    }

    /**
     * 创建工具实例
     *
     * @param authServer 认证服务器地址
     * @return 工具实例
     */
    public static UserTransferHelper getInstance(@NotBlank String authServer) {
        if (transferHelper == null) {
            synchronized (UserTransferHelper.class) {
                if (transferHelper == null) {
                    transferHelper = new UserTransferHelper(authServer);
                }
            }
        }
        return transferHelper;
    }

    /**
     * 同步用户
     *
     * @param userInfo 用户信息
     * @return 用户ID
     */
    public Result<Long> upsertUser(AuthUserDTO userInfo) {
        var result = proxy.upsertUser(AuthCompatibilityUtil.convert(userInfo));
        return AuthCompatibilityUtil.convert(result);
    }

    /**
     * 批量同步用户
     *
     * @param rollBackAllOnException 出现异常，是否回滚所有
     * @param userInfoList           用户信息列表
     * @return username map userId
     */
    public Result<HashMap<String, Long>> upsertUserBatch(boolean rollBackAllOnException, List<AuthUserDTO> userInfoList) {
        var userList = AuthCompatibilityUtil.convert(userInfoList);
        var result = proxy.upsertUserBatch(rollBackAllOnException, userList);
        return AuthCompatibilityUtil.convert(result);
    }

    /**
     * 更新用户状态
     *
     * @param userId  用户ID
     * @param enabled 启用状态
     * @return 用户ID
     */
    public Result<Long> updateEnabled(long userId, boolean enabled) {
        var result = proxy.updateEnabled(userId, enabled);
        return AuthCompatibilityUtil.convert(result);
    }

    /**
     * 修改用户的密码
     *
     * @param userId 用户账号ID
     * @param pd     密码，明文
     * @return 用户ID
     * @deprecated 请使用 {@link #updatePwd(long, String)}
     */
    public Result<Long> updatePassword(long userId, String pd) {
        var result = proxy.updatePassword(userId, pd);
        return AuthCompatibilityUtil.convert(result);
    }

    /**
     * 修改用户的密码
     *
     * @param updateDTO 用户账号密码信息
     * @return 用户ID
     */
    public Result<Long> updatePwd(AuthPwdUpdateDTO updateDTO) {
        var result = proxy.updatePwd(updateDTO);
        return AuthCompatibilityUtil.convert(result);
    }

    /**
     * 修改用户的手机号
     *
     * @param userId 用户账号ID
     * @param mobile 手机号
     * @return 用户ID
     */
    public Result<Long> updateMobile(long userId, String mobile) {
        var result = proxy.updateMobile(userId, mobile);
        return AuthCompatibilityUtil.convert(result);
    }

    /**
     * 修改用户的邮箱
     *
     * @param userId 用户账号ID
     * @param email  邮箱
     * @return 用户ID
     */
    public Result<Long> updateEmail(long userId, String email) {
        var result = proxy.updateEmail(userId, email);
        return AuthCompatibilityUtil.convert(result);
    }

    /**
     * 修改用户的账号到期时间
     *
     * @param userId      用户账号ID
     * @param expiredTime 账号过期时间，格式yyyy-MM-dd HH:mm:ss
     * @return 用户ID
     */
    public Result<Long> updateExpiredTime(long userId, String expiredTime) {
        var result = proxy.updateExpiredTime(userId, expiredTime);
        return AuthCompatibilityUtil.convert(result);
    }

    /**
     * 修改用户的密码到期时间
     *
     * @param userId      用户账号ID
     * @param expiredTime 密码过期时间，格式yyyy-MM-dd HH:mm:ss
     * @return 用户ID
     */
    public Result<Long> updatePwdExpiredTime(long userId, String expiredTime) {
        var result = proxy.updatePwdExpiredTime(userId, expiredTime);
        return AuthCompatibilityUtil.convert(result);
    }

    /**
     * 删除用户账号
     *
     * @param userId 用户账号ID
     * @return 用户账号ID
     */
    public Result<Long> delete(long userId) {
        var result = proxy.delete(userId);
        return AuthCompatibilityUtil.convert(result);
    }

    /**
     * 根据ID获取用户信息
     *
     * @param userId 用户账号ID
     * @return 用户信息
     */
    public Result<AuthUserDTO> getUser(long userId) {
        var result = proxy.getUser(userId);
        return AuthCompatibilityUtil.convert(result, AuthCompatibilityUtil::convert);
    }

    /**
     * 根据username获取用户信息
     *
     * @param username 用户账号
     * @return 用户信息
     */
    public Result<AuthUserDTO> getUserByUsername(String username) {
        var result = proxy.getUserByUsername(username);
        return AuthCompatibilityUtil.convert(result, AuthCompatibilityUtil::convert);
    }

    /**
     * 根据手机号获取用户信息
     *
     * @param mobile 手机号
     * @return 用户信息
     */
    public Result<AuthUserDTO> getUserByMobile(String mobile) {
        var result = proxy.getUserByMobile(mobile);
        return AuthCompatibilityUtil.convert(result, AuthCompatibilityUtil::convert);
    }

    /**
     * 根据邮箱获取用户信息
     *
     * @param email 邮箱
     * @return 用户信息
     */
    public Result<AuthUserDTO> getUserByEmail(String email) {
        var result = proxy.getUserByEmail(email);
        return AuthCompatibilityUtil.convert(result, AuthCompatibilityUtil::convert);
    }

    /**
     * 获取用户列表
     *
     * @param userIds 用户账号ID
     * @return 用户信息
     */
    public Result<ArrayList<AuthUserDTO>> getUserList(List<Long> userIds) {
        var result = proxy.getUserList(userIds);
        return AuthCompatibilityUtil.convert(result, AuthCompatibilityUtil::convert);
    }

    /**
     * 获取用户列表
     *
     * @param queryDTO 查询参数
     * @return 用户信息
     */
    public Result<ArrayList<AuthUserDTO>> queryUserList(AuthUserQueryDTO queryDTO) {
        var result = proxy.queryUserList(queryDTO);
        return AuthCompatibilityUtil.convert(result, AuthCompatibilityUtil::convert);
    }

    /**
     * 获取用户ID
     *
     * @param usernames 用户账号
     * @return 用户ID
     */
    public Result<HashMap<String, Long>> getUserIdByUsername(List<String> usernames) {
        var result = proxy.getUserIdByUsername(usernames);
        return AuthCompatibilityUtil.convert(result);
    }

    /**
     * 获取用户ID
     *
     * @param mobiles 手机号
     * @return 用户ID
     */
    public Result<HashMap<String, Long>> getUserIdByMobile(List<String> mobiles) {
        var result = proxy.getUserIdByMobile(mobiles);
        return AuthCompatibilityUtil.convert(result);
    }

    /**
     * 获取用户ID
     *
     * @param emails 邮箱
     * @return 用户ID
     */
    public Result<HashMap<String, Long>> getUserIdByEmail(List<String> emails) {
        var result = proxy.getUserIdByEmail(emails);
        return AuthCompatibilityUtil.convert(result);
    }


}
