/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.cas.config;

import com.elitescloud.boot.auth.cas.AuthorizeCacheable;
import com.elitescloud.boot.auth.cas.UserSourceProvider;
import com.elitescloud.boot.auth.cas.provider.OAuth2ClientTemplate;
import com.elitescloud.boot.auth.cas.provider.impl.DefaultOAuth2ClientTemplate;
import com.elitescloud.boot.auth.cas.task.CasClientScheduler;
import com.elitescloud.boot.auth.config.AuthorizationSdkProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.core.task.TaskExecutor;
import org.springframework.lang.NonNull;

@ConditionalOnProperty(prefix="elitesland.authorization.sdk.cas-client", name={"enabled"}, havingValue="true")
public class CasClientConfig
implements ApplicationContextAware,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(CasClientConfig.class);
    private final AuthorizationSdkProperties sdkProperties;
    private ApplicationContext applicationContext;

    public CasClientConfig(AuthorizationSdkProperties sdkProperties) {
        this.sdkProperties = sdkProperties;
        LOG.info("\u7edf\u4e00\u8eab\u4efd\u8ba4\u8bc1\u5ba2\u6237\u7aef\u8ba4\u8bc1\u542f\u7528");
    }

    public void afterPropertiesSet() throws Exception {
        UserSourceProvider userSourceProvider = (UserSourceProvider)this.applicationContext.getBeanProvider(UserSourceProvider.class).getIfAvailable();
        if (userSourceProvider == null) {
            LOG.warn("\u672a\u80fd\u6210\u529f\u540c\u6b65\u7528\u6237\u8d26\u53f7\uff0c\u672a\u53d1\u73b0\u914d\u7f6e\u6709\u6548\u7684{}", (Object)UserSourceProvider.class.getName());
        }
    }

    public void setApplicationContext(@NonNull ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Bean
    @ConditionalOnMissingBean
    public OAuth2ClientTemplate oAuth2ClientTemplate(ObjectProvider<AuthorizeCacheable> authorizeCacheable) {
        return new DefaultOAuth2ClientTemplate(this.sdkProperties, (AuthorizeCacheable)authorizeCacheable.getIfAvailable());
    }

    @Bean
    public CasClientScheduler authorizationSdkScheduler(TaskExecutor taskExecutor) {
        return new CasClientScheduler(this.sdkProperties, taskExecutor);
    }
}

