/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.cas.provider;

import com.elitescloud.boot.auth.cas.provider.CasUrlConstant;
import com.elitescloud.boot.auth.cas.task.ClientTokenHolder;
import com.elitescloud.boot.auth.model.OAuthToken;
import com.elitescloud.boot.auth.model.UpdaterInfoDTO;
import com.elitescloud.boot.common.OpenApiException;
import com.elitescloud.boot.util.RestTemplateFactory;
import com.elitescloud.boot.util.RestTemplateHelper;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.lang.NonNull;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public abstract class BaseTransferHelper {
    private static final Logger LOG = LoggerFactory.getLogger(BaseTransferHelper.class);
    private final RestTemplateHelper restTemplateHelper = RestTemplateHelper.instance((RestTemplate)RestTemplateFactory.dynamicInstance(builder -> builder.rootUri(authServer).additionalInterceptors(new ClientHttpRequestInterceptor[]{new AuthorizationInterceptor()}), (String[])new String[]{"cloudt-authorization"}));

    BaseTransferHelper(String authServer) {
    }

    <T> T nullToDefault(T obj, T defaultObj) {
        return obj == null ? defaultObj : obj;
    }

    <T> T remoteExchange(String url, HttpMethod httpMethod, HttpEntity<?> httpEntity, TypeReference<T> responseType, Object ... param) {
        try {
            return (T)this.restTemplateHelper.exchangeSafely(url, httpMethod, httpEntity, responseType, param);
        }
        catch (OpenApiException e) {
            if (e.getCode() == HttpStatus.UNAUTHORIZED.value()) {
                LOG.info("\u91cd\u8bd5\u8bf7\u6c42\uff1a{}", (Object)url);
                ClientTokenHolder.refresh();
                return (T)this.restTemplateHelper.exchangeSafely(url, httpMethod, httpEntity, responseType, param);
            }
            throw e;
        }
    }

    UpdaterInfoDTO createUpdaterInfo() {
        HttpServletRequest request;
        UpdaterInfoDTO updaterInfoDTO = new UpdaterInfoDTO();
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null) {
            updaterInfoDTO.setUpdater(authentication.getName());
        }
        if ((request = this.currentRequest()) != null) {
            updaterInfoDTO.setIp(this.getClientIp(request));
            updaterInfoDTO.setBrowserAgent(request.getHeader("User-Agent"));
        }
        return updaterInfoDTO;
    }

    HttpServletRequest currentRequest() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes == null) {
            return null;
        }
        return ((ServletRequestAttributes)requestAttributes).getRequest();
    }

    String getClientIp(HttpServletRequest request) {
        List<String> headers = Arrays.asList("X-Forwarded-For", "X-Real-IP", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_CLIENT_IP", "HTTP_X_FORWARDED_FOR");
        for (String header : headers) {
            String headerValue = request.getHeader(header);
            if (!this.isUnknown(headerValue)) continue;
            return this.getFirstValue(headerValue, ",");
        }
        return request.getRemoteAddr();
    }

    private String getFirstValue(String value, String separator) {
        if (!StringUtils.hasText((String)value)) {
            return value;
        }
        for (String s : value.split(separator)) {
            String temp = s.trim();
            if (this.isUnknown(temp)) continue;
            return temp;
        }
        return value;
    }

    private boolean isUnknown(String ip) {
        return !StringUtils.hasText((String)ip) || "unknown".equalsIgnoreCase(ip);
    }

    static class AuthorizationInterceptor
    implements ClientHttpRequestInterceptor {
        AuthorizationInterceptor() {
        }

        @NonNull
        public ClientHttpResponse intercept(HttpRequest request, @NonNull byte[] body, @NonNull ClientHttpRequestExecution execution) throws IOException {
            if (!CasUrlConstant.needToken(request.getURI())) {
                return execution.execute(request, body);
            }
            HttpHeaders headers = request.getHeaders();
            OAuthToken token = ClientTokenHolder.getToken();
            if (token == null) {
                throw new IllegalStateException("Token\u83b7\u53d6\u5931\u8d25");
            }
            headers.add("Authorization", token.getTokenType() + " " + token.getAccessToken());
            return execution.execute(request, body);
        }
    }
}

