/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.resolver.impl;

import com.elitescloud.boot.auth.resolver.UniqueRequestResolver;
import java.time.Duration;
import java.util.Random;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.StringUtils;

public class DefaultUniquestResolver
implements UniqueRequestResolver {
    private final String seqName;
    private String cookiePath = "/";
    private boolean cookieHttpOnly = true;
    private boolean cookieSecure = false;
    private int cookieMaxAge = (int)Duration.ofDays(7L).toSeconds();

    public DefaultUniquestResolver(String seqName) {
        this.seqName = seqName;
    }

    @Override
    public String signRequest(HttpServletResponse response) {
        String seqId = this.generateSeqId();
        response.setHeader(this.seqName, seqId);
        Cookie cookie = new Cookie(this.seqName, seqId);
        cookie.setPath(this.cookiePath);
        cookie.setHttpOnly(this.cookieHttpOnly);
        cookie.setSecure(this.cookieSecure);
        cookie.setMaxAge(this.cookieMaxAge);
        response.addCookie(cookie);
        return seqId;
    }

    @Override
    public String analyze(HttpServletRequest request) {
        String reqId = request.getHeader(this.seqName);
        if (StringUtils.hasText((String)reqId)) {
            return reqId;
        }
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!this.seqName.equalsIgnoreCase(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    @Override
    public void clear(HttpServletResponse response, String reqId) {
        if (!StringUtils.hasText((String)reqId)) {
            return;
        }
        Cookie cookie = new Cookie(this.seqName, reqId);
        cookie.setPath(this.cookiePath);
        cookie.setMaxAge(0);
        response.addCookie(cookie);
    }

    public void setCookiePath(String cookiePath) {
        this.cookiePath = cookiePath;
    }

    public void setCookieHttpOnly(boolean cookieHttpOnly) {
        this.cookieHttpOnly = cookieHttpOnly;
    }

    public void setCookieSecure(boolean cookieSecure) {
        this.cookieSecure = cookieSecure;
    }

    public void setCookieMaxAge(int cookieMaxAge) {
        this.cookieMaxAge = cookieMaxAge;
    }

    private String generateSeqId() {
        String state = "" + System.nanoTime();
        Random random = new Random();
        StringBuilder stateBuilder = new StringBuilder(state);
        for (int i = 0; i < 8; ++i) {
            stateBuilder.append(random.nextInt(10));
        }
        return stateBuilder.toString();
    }
}

