/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.sso.configurer.filter;

import com.elitescloud.boot.auth.config.AuthorizationSdkProperties;
import com.elitescloud.boot.auth.sso.SsoProvider;
import com.elitescloud.boot.auth.sso.TicketResolver;
import com.elitescloud.boot.auth.sso.common.TicketAuthentication;
import com.elitescloud.boot.auth.sso.model.UserInfoDTO;
import com.elitescloud.boot.auth.util.AuthorizationServerHelper;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public class CloudtSsoFilter
extends OncePerRequestFilter {
    private static final Logger LOG = LoggerFactory.getLogger(CloudtSsoFilter.class);
    private final AuthorizationSdkProperties sdkProperties;
    private TicketResolver ticketResolver;
    private SsoProvider ssoProvider;
    private AuthenticationSuccessHandler authenticationSuccessHandler;
    private AuthenticationFailureHandler authenticationFailureHandler;
    private final AuthorizationServerHelper authorizationServerHelper = AuthorizationServerHelper.getInstance();
    private final ObjectMapper objectMapper = new ObjectMapper();

    public CloudtSsoFilter(AuthorizationSdkProperties sdkProperties) {
        this.sdkProperties = sdkProperties;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (this.supportAuthorize(request)) {
            this.ssoAuthorize(request, response);
            return;
        }
        if (this.supportRevoke(request)) {
            this.ssoRevoke(request, response);
            return;
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void setSsoProvider(SsoProvider ssoProvider) {
        this.ssoProvider = ssoProvider;
    }

    public void setTicketResolver(TicketResolver ticketResolver) {
        this.ticketResolver = ticketResolver;
    }

    public void setAuthenticationSuccessHandler(AuthenticationSuccessHandler authenticationSuccessHandler) {
        this.authenticationSuccessHandler = authenticationSuccessHandler;
    }

    public void setAuthenticationFailureHandler(AuthenticationFailureHandler authenticationFailureHandler) {
        this.authenticationFailureHandler = authenticationFailureHandler;
    }

    private void ssoAuthorize(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.ssoProvider != null && this.ssoProvider.isAuthenticated(request)) {
            this.respAuthorized(response, false, null);
            return;
        }
        UserInfoDTO userInfoDTO = null;
        String ticket = this.ticketResolver.obtain(request);
        if (StringUtils.hasText((String)ticket)) {
            userInfoDTO = this.obtainUser(ticket);
        }
        if (userInfoDTO == null) {
            this.respLogin(response);
            return;
        }
        TicketAuthentication authentication = new TicketAuthentication(ticket, userInfoDTO);
        if (this.ssoProvider != null) {
            try {
                authentication = this.ssoProvider.authentication(request, response, authentication);
            }
            catch (Exception e) {
                LOG.info("\u8ba4\u8bc1\u5931\u8d25\uff1a{}", (Object)e.getMessage());
                this.respLogin(response);
                return;
            }
        } else {
            authentication = new TicketAuthentication(ticket, userInfoDTO, Collections.emptyList());
        }
        if (authentication.isAuthenticated()) {
            if (this.authenticationSuccessHandler != null) {
                this.authenticationSuccessHandler.onAuthenticationSuccess(request, response, (Authentication)authentication);
            }
        } else if (this.authenticationFailureHandler != null) {
            this.authenticationFailureHandler.onAuthenticationFailure(request, response, (AuthenticationException)new AuthenticationServiceException("\u8ba4\u8bc1\u5931\u8d25"));
        }
        this.ticketResolver.save(request, response, ticket);
        this.respAuthorized(response, true, authentication.getToken());
    }

    private void ssoRevoke(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String ticket = this.ticketResolver.obtain(request);
        if (this.ssoProvider != null) {
            this.ssoProvider.clearToken(request, response, ticket);
        }
        if (StringUtils.hasText((String)ticket)) {
            String server = request.getParameter("server");
            if (!"true".equalsIgnoreCase(server)) {
                this.authorizationServerHelper.revokeTicket(this.sdkProperties.getAuthServer(), ticket);
            }
            this.ticketResolver.clear(request, response);
        }
        this.respLogin(response);
    }

    private boolean supportAuthorize(HttpServletRequest request) {
        if (!StringUtils.hasText((String)this.sdkProperties.getSso().getAuthorizeEndpoint())) {
            LOG.error("\u5355\u70b9\u767b\u5f55\u62e6\u622a\u5931\u6548\uff0c\u8ba4\u8bc1\u5730\u5740\u672a\u914d\u7f6e\uff01");
            return false;
        }
        return request.getRequestURI().equals(this.sdkProperties.getSso().getAuthorizeEndpoint());
    }

    private boolean supportRevoke(HttpServletRequest request) {
        if (!StringUtils.hasText((String)this.sdkProperties.getSso().getAuthorizeRevokeEndpoint())) {
            LOG.error("\u5355\u70b9\u767b\u5f55\u7684\u6ce8\u9500\u5730\u5740\u672a\u914d\u7f6e\uff01");
            return false;
        }
        return request.getRequestURI().equals(this.sdkProperties.getSso().getAuthorizeRevokeEndpoint());
    }

    private UserInfoDTO obtainUser(String ticket) {
        UserInfoDTO userInfoDTO = null;
        try {
            userInfoDTO = this.authorizationServerHelper.ticket2UserInfo(this.sdkProperties.getAuthServer(), ticket);
        }
        catch (Exception e) {
            this.logger.error((Object)"\u5355\u70b9\u767b\u5f55\u5f02\u5e38\uff1a", (Throwable)e);
        }
        if (userInfoDTO == null) {
            LOG.info("\u672a\u89e3\u6790\u5230\u6709\u6548\u7528\u6237\u4fe1\u606f\uff0c\u9700\u767b\u5f55");
        }
        return userInfoDTO;
    }

    private void respAuthorized(HttpServletResponse response, boolean sso, Serializable token) throws IOException {
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        response.setContentType("application/json");
        response.setStatus(HttpStatus.OK.value());
        try (PrintWriter writer = response.getWriter();){
            String result = this.objectMapper.writeValueAsString((Object)new AuthorizedResult(true, sso ? "SSO\u670d\u52a1\u5df2\u8ba4\u8bc1" : "\u670d\u52a1\u5df2\u8ba4\u8bc1", token));
            writer.write(result);
        }
    }

    private void respLogin(HttpServletResponse response) throws IOException {
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        response.setContentType("application/json");
        response.setStatus(HttpStatus.UNAUTHORIZED.value());
        try (PrintWriter writer = response.getWriter();){
            String result = this.objectMapper.writeValueAsString((Object)new AuthorizedResult(false, "\u8bf7\u91cd\u65b0\u767b\u5f55"));
            writer.write(result);
        }
    }

    static class AuthorizedResult
    implements Serializable {
        private static final long serialVersionUID = -4599981681764185389L;
        private final boolean authorized;
        private final String msg;
        private final Serializable token;

        public AuthorizedResult() {
            this.authorized = false;
            this.msg = "";
            this.token = null;
        }

        public AuthorizedResult(boolean authorized, String msg) {
            this.authorized = authorized;
            this.msg = msg;
            this.token = null;
        }

        public AuthorizedResult(boolean authorized, String msg, Serializable token) {
            this.authorized = authorized;
            this.msg = msg;
            this.token = token;
        }

        public boolean isAuthorized() {
            return this.authorized;
        }

        public String getMsg() {
            return this.msg;
        }

        public Serializable getToken() {
            return this.token;
        }
    }
}

