package com.elitescloud.boot.datasecurity.dpr.service;

import cn.zhxu.bs.util.MapBuilder;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiDataRuleListQueryDTO;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiRowColumnRuleDTO;

import java.util.List;
import java.util.Map;

/**
 * @author : chen
 * 数据权限规则解析接口
 * 需要bean Seacher和jpa分别实现。
 * @date 2022-11-24 14:12
 */
public interface RoleDataPermissionRuleService {

    /**
     * 当前用户的角色数据权限数据获取业务接口
     *
     * @return 规则组组-规则对象集合
     */
    SysDprRoleApiRowColumnRuleDTO getUserRoleDpr();


    /**
     * 当前用户的角色数据权限数据获取业务接口， 采用beanSearcher map构造数据权限的检索参数
     * @param beanClass beanSearcher类
     * @param pathObj 路径传参时，路径参数。 通前端规则配置的路径传参占位符： {0} {1} {3}  如果没有可以空
     * @return bs的map构造器
     *  MapBuilder userRdpRuleSqlBeanSearcherHandleEngine( Class<?> beanClass,String... pathObj);
     */

    /**
     * 租户和数据权限条件追加，根据beansearcher的bean，查询参数，API路径参数。 追加数据权限
     **/
    MapBuilder tenantAuthSearcherHandleEngine(Class<?> classBean,
                                              Map<String, Object> params,
                                              String... pathObj);

    /**
     * 租户条件追加 根据beansearcher的bean，查询参数，API路径参数。 追加数据权限
     **/
    MapBuilder tenantSearcherHandleEngine(Class<?> beanClass, Map<String, Object> paraMap,
                                          String... pathObj);

    /**
     * 返回beansear分组关系的正则表达式，没有实际用途，可以看。
     *
     * @param params bs的参数集合
     * @return 返回分组正则字符串
     */
    Object getBeanSearcherGroupExpr(Map<String, Object> params);

    /**
     * 根据规则，构造BS的参数对象和分组表达式
     * **/
    StringBuilder ruleAuthBuilder(MapBuilder mapBuilder,
                         List<SysDprRoleApiDataRuleListQueryDTO> ruleList);

    /**
     * 追加设置beanSearcher分组关系的正则表达式，是在已有的正则表达式基础上追加。 主要开头需要增加追加关系标识符 |或 &
     *
     * @param params    bs的参数集合
     * @param groupExpr bs要追加的分组正则
     */
    void addSetBeanSearcherGroupExpr(Map<String, Object> params, String groupExpr);

//    /**
//     * @description 当前用户的角色数据权限数据获取业务接口
//     * @param @param null
//     * @return
//     */
//    MapBuilder userRdpRuleSqlBeanSearcherHandleEngine( Class<?> beanClass);

//    Object userRdpRuleSqlJpaHandleEngine();


}
