package com.elitescloud.cloudt.core.security.util;

import com.elitescloud.boot.datasecurity.dataauth.AuthScope;
import com.elitescloud.cloudt.authorization.core.SecurityContextUtil;
import com.elitescloud.cloudt.common.base.QBaseModel;
//import com.elitescloud.cloudt.core.entity.QSecOrgBuTreedDO;
//import com.elitescloud.cloudt.core.entity.QSecOrgEmpDO;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.PathMetadata;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.impl.JPAQuery;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * <p>
 * 数据权限相关工具类
 * </p >
 *
 * @author niu.chen
 * @date 2021-07-07
 * @deprecated 请使用新版数据权限
 */
@Deprecated(forRemoval = true, since = "3.2.0")
public class DataAuthJpaUtil {

    /**
     * 私有构造起，防止其他人创建
     */
    private DataAuthJpaUtil() {
    }

    /**
     * 存储前端传递的应用name
     */
    private static final String ROUTE_KEY = "RouteKey";

//    private static final QSecOrgBuTreedDO secOrgBuTreedDO = QSecOrgBuTreedDO.secOrgBuTreedDO;
//    private static final QSecOrgEmpDO secOrgEmpDO = QSecOrgEmpDO.secOrgEmpDO;

    /**
     * 决定是否开启数据权限
     */
    private static boolean dataPermissionEnable = false;

    /**
     * 数据权限过滤
     *
     * @param query    查询 query
     * @param metadata 表
     * @param <T>      泛型
     */
    public static <T> void dataAuthJpaFilter(JPAQuery<T> query, PathMetadata metadata) {
        dataAuthFilter(query, metadata, null);
    }

    /**
     * 数据权限过滤
     *
     * @param query     查询 query
     * @param metadata  表
     * @param threshold 使用 left join 的门槛
     * @param <T>       泛型
     */
    public static <T> void dataAuthJpaFilter(JPAQuery<T> query, PathMetadata metadata, int threshold) {
        dataAuthFilter(query, metadata, threshold);
    }

    /**
     * 拼接 where 条件入口
     *
     * @param metadata 表
     * @return where 条件
     */
    private static <T> void dataAuthFilter(JPAQuery<T> query, PathMetadata metadata, Integer threshold) {
        // ======== 1. 获取当前用户信息包括各种权限对象。 ========
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        // ======== 2. 获取 BaseModel ========
        var qBaseModel = new QBaseModel(metadata);
        // ======== 3. 获取应用名 ========
        String route = getRequestSysDataRoute();

        // ======== 4. 校验 ========
        var predicate = preCheck(user, qBaseModel, route);
        if (predicate != null) {
            query.where(predicate);
            return;
        }

        var authScope = sysDataRoleOperation(user, route, true);

        buildCodePathPredicate(query, qBaseModel, user, authScope, threshold);
    }

    /**
     * 集成了架构用户权限获取和 spring http request请求方法
     * 1.获取当前登录用户数据权限信息。 数据权限角色，角色中的权限配置
     * 2.获取当前请求前端应用通过request中header传递的应用名称。
     * 3.运算多个数据角色中的数据配置和应用配置，算出最终的数据权限对象。 包括：组织授权集合，用户授权集合
     * 4.   QueryDsl Predicate查询条件对象。 回给业务开发
     *
     * @param metadata 表元数据信息 以那个表维度增加条件
     * @return predicate   查询条件
     */
    public static Predicate dataAuthJpaPredicate(PathMetadata metadata) {

        // ======== 1. 获取当前用户信息包括各种权限对象。 ========
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        // ======== 2. 获取 BaseModel ========
        var qBaseModel = new QBaseModel(metadata);
        // ======== 3. 获取应用名 ========
        String route = getRequestSysDataRoute();

        // ======== 4. 校验 ========
        var predicate = preCheck(user, qBaseModel, route);
        if (predicate != null) {
            return predicate;
        }
        return null;

    }

    /**
     * 前置校验，决定是否需要进行数据权限过滤
     *
     * @param user       当前登录人信息
     * @param qBaseModel 表
     * @param route      当前应用
     * @return where 条件
     */
    private static Predicate preCheck(GeneralUserDetails user, QBaseModel qBaseModel, String route) {


        // ======== 前置校验，校验放在所有动作之前，保证效率 ========
        if (!dataPermissionEnable) {
            // 1 如果没有启用数据权限控制，则直接返回一个必然为 true 的判断
            // return qBaseModel.id.isNotNull();
            //  return Expressions.booleanTemplate("1=1");
            return Expressions.booleanTemplate("1=1");

//        } else if (StringUtils.isBlank(route)) {
//            // 2 如果应用编号为空，则抛出异常
//            throw new BusinessException(ApiCode.FAIL, "数据权限异常，RouteKey 为空");

        } else if (user == null || user.getUser() == null) {
            // 3 如果用户信息为空，则说明是匿名用户，则直接返回一个必然为 true 的判断
            // 匿名用户需要返回所有数据，否则 swagger 将无法调试
            //   return qBaseModel.id.isNotNull();
            // return Expressions.asBoolean(true).isTrue();
            return Expressions.booleanTemplate("1=1");

        } else if (user.isSystemAdmin() || user.isTenantAdmin()) {
            // return qBaseModel.id.isNotNull();
            // return Expressions.asBoolean(true).isTrue();
            return Expressions.booleanTemplate("1=1");

        } /*else if (CollectionUtils.isEmpty(user.getUser().getSysDataRoleVOS())) {
            // 4 用户没有绑定数据角色，则返回一个必为 false 的判断，查不出任何数据
            return qBaseModel.id.isNull();

        } else if (user.getUser().getSysDataRoleVOS().stream().map(SysDataRoleVO::getCode)
                .anyMatch(t ->
                        RoleWhiteListEnum.ADMIN.name().equals(t) || RoleWhiteListEnum.TENANT_ADMIN.name().equals(t)
                )) {
            // 5 如果拥有数据角色的管理员角色，则直接返回一个必然为 true 的判断
            qBaseModel.isNull();
            //return qBaseModel.id.isNotNull();
            // return Expressions.booleanTemplate("1=1");
            return Expressions.booleanTemplate("1=1");
//
//        } else if (user.getSecurityOrgUserEmpBuDTO() == null || user.getSecurityOrgUserEmpBuDTO().getEmpId() == null) {
//            // 6 没获取到员工信息，则返回一个必为 false 的判断，查不出任何数据
//            return qBaseModel.id.isNull();
////            throw new BusinessException(ApiCode.FAIL, "数据权限异常，登录没有获取到组织与员工信息");
        } */else {
            // 校验通过，返回 null
            var authScope = sysDataRoleOperation(user, route, false);

            return buildIdInPredicate(qBaseModel, user, authScope);
        }
    }

    /**
     * 构建 where 条件，使用 codePath like
     *
     * @param qBaseModel 表
     * @param user       当前登录人信息
     * @param authScope  授权范围
     * @param threshold  门槛，小于等于这个门槛，则使用 in，高于这个数字，使用 codePath like 的方式，如果为空，则默认使用 id in
     */
    private static <T> void buildCodePathPredicate(JPAQuery<T> query, QBaseModel qBaseModel, GeneralUserDetails user, AuthScope authScope, Integer threshold) {
        List<Predicate> predicates = new ArrayList<>();

        // 保存 bu id in 的 id
        Set<Long> buIds = new HashSet<>();
        // 保存 emp id in 的 id
        Set<Long> empIds = new HashSet<>();

        // 1.1 拼接 绑定的 bu id
        if (CollectionUtils.isNotEmpty(authScope.getBuIds())) {
            buIds.addAll(authScope.getBuIds());
        }
        // 1.2 拼接 自定义 bu id
        if (CollectionUtils.isNotEmpty(authScope.getCustomizedBuIds())) {
            buIds.addAll(authScope.getCustomizedBuIds());
        }
        // 1.3 拼接 下级(包括自己) bu id 或 bu codePath like 语句
        if (CollectionUtils.isNotEmpty(authScope.getChildBuIds()) && CollectionUtils.isNotEmpty(authScope.getBuCodePath())) {
            if (threshold == null || (buIds.size() + authScope.getChildBuIds().size()) <= threshold) {
                buIds.addAll(authScope.getChildBuIds());
            } else {
        /*        var buTreeId = user.getSecurityOrgUserEmpBuDTO().getEmpBuTreeId();
                query.leftJoin(secOrgBuTreedDO).on(
                        secOrgBuTreedDO.buTreeId.eq(buTreeId)
                                .and(secOrgBuTreedDO.buId.eq(qBaseModel.secBuId))
                );*/

//                List<Predicate> codePathLike = authScope.getBuCodePath().stream()
//                        .map(path -> secOrgBuTreedDO.codePath.like(path + "%")).collect(Collectors.toList());
//                predicates.add(ExpressionUtils.anyOf(codePathLike));
            }
        }
        // 1.4 拼接 bu id in 条件
        if (CollectionUtils.isNotEmpty(buIds)) {
            predicates.add(qBaseModel.secBuId.in(buIds));
        }


        // 2.2 拼接 所属 emp id
        if (CollectionUtils.isNotEmpty(authScope.getEmpIds())) {
            empIds.addAll(authScope.getEmpIds());
        }
        // 2.3 拼接 自定义 emp id
        if (CollectionUtils.isNotEmpty(authScope.getCustomizedEmpIds())) {
            empIds.addAll(authScope.getCustomizedEmpIds());
        }
        // 2.1 拼接 下级(包括自己) emp id 或 emp codePath like 语句
        if (CollectionUtils.isNotEmpty(authScope.getChildEmpIds()) && CollectionUtils.isNotEmpty(authScope.getEmpCodePath())) {
            if (threshold == null || (empIds.size() + authScope.getChildEmpIds().size()) <= threshold) {
                empIds.addAll(authScope.getChildEmpIds());
            } else {
//                query.leftJoin(secOrgEmpDO).on(
//                        secOrgEmpDO.id.eq(qBaseModel.secUserId)
//                );

//                List<Predicate> codePathLike = authScope.getEmpCodePath().stream()
//                        .map(path -> secOrgEmpDO.codePath.like(path + "%")).collect(Collectors.toList());
//                predicates.add(ExpressionUtils.anyOf(codePathLike));
            }
        }
        // 2.4 拼接 emp id in 条件
        if (CollectionUtils.isNotEmpty(empIds)) {
            predicates.add(qBaseModel.secUserId.in(empIds));
        }

        // 3.1 拼接所属公司和自定义公司
        if (CollectionUtils.isNotEmpty(authScope.getOuIds())) {
            predicates.add(qBaseModel.secOuId.in(authScope.getOuIds()));
        }

        // 4 最后构建 where 条件
        if (CollectionUtils.isNotEmpty(predicates)) {
            predicates.add(qBaseModel.createUserId.eq(user.getUser().getId()));
            query.where(ExpressionUtils.anyOf(predicates));
        }
    }

    /**
     * 最终步骤，拼接查询条件
     *
     * @param qBaseModel 表
     * @param authScope  承载计算出来的条件，非 auth 实体本身实际含义
     * @return 查询条件
     */
    private static Predicate buildIdInPredicate(QBaseModel qBaseModel, GeneralUserDetails user, AuthScope authScope) {

        var buIds = authScope.getBuIds();
        var userIds = authScope.getEmpIds();
        var ouIds = authScope.getOuIds();

        List<Predicate> predicates = new ArrayList<>();
        // 组织
        if (CollectionUtils.isNotEmpty(buIds)) {
            predicates.add(qBaseModel.secBuId.in(buIds));
        }
        // 员工
        if (CollectionUtils.isNotEmpty(userIds)) {
            predicates.add(qBaseModel.secUserId.in(userIds));
        }
        // 公司
        if (CollectionUtils.isNotEmpty(ouIds)) {
            predicates.add(qBaseModel.secOuId.in(ouIds));
        }

        // 返回 where 条件
        if (CollectionUtils.isNotEmpty(predicates)) {
            // 创建人等于当前登录人ID，该查询条件和查询条件组合，使用 or 组合，如果没有条件需要拼接，则也不拼接这条
            predicates.add(qBaseModel.createUserId.eq(user.getUser().getId()));
            return ExpressionUtils.anyOf(predicates);
        } else {
            // 都为空，则不需要拼接条件，返回一个 true 条件
            //  return qBaseModel.id.isNotNull();
            // return Expressions.booleanTemplate("1=1");
            return Expressions.booleanTemplate("1=1");
        }
    }

    /**
     * 核心方法.  合并当前用户的数据角色权限对象。 包括：权限类型，组织权限集合，管辖人权限集合。
     *
     * @param user  当前用户
     * @param route 应用编号
     * @return 计算出来的，承载查询必要信息的类，非 auth 实体对象含义
     */
    private static AuthScope sysDataRoleOperation(GeneralUserDetails user, String route, boolean isCodePath) {

        // ======== 1. 数据角色和权限集合。 ========
//        Set<SysDataRoleVO> sysDataRoleVos = user.getUser().getSysDataRoleVOS();
        // ======== 2. 获取支撑域组织和员工扩展信息 ========
//        SecurityOrgUserEmpBuDTO userSupportDetailsDto = user.getSecurityOrgUserEmpBuDTO();


        // ======== 3. 初始化授权数据 ========
        AuthScope authScope = new AuthScope();

        // ======== 4. 计算授权ID ========
//        var advancedSysDataAuthVos = sysDataRoleVos.stream()
//                .filter(vo ->
//                        vo.getAdvancedEnable() != null
//                                && vo.getAdvancedEnable()
//                                && vo.getStringSysDataPermissionVOMap() != null
//                                && vo.getStringSysDataPermissionVOMap().containsKey(route))
//                .map(vo -> vo.getStringSysDataPermissionVOMap().get(route)).filter(Objects::nonNull).collect(Collectors.toList());
//
//        if (CollectionUtils.isNotEmpty(advancedSysDataAuthVos)) {
//            // 4.1 如果高级授权不为空，则使用高级授权计算 授权ID
//            if (isCodePath) {
//                calculateAuthScope(userSupportDetailsDto, advancedSysDataAuthVos, authScope);
//            } else {
//                calculateAuthIds(userSupportDetailsDto, advancedSysDataAuthVos, authScope);
//            }
//        } else {
//            // 4.2 如果高级授权为空，则使用基础授权计算 授权ID
//            var basicSysDataAuthVos = sysDataRoleVos.stream()
//                    .map(SysDataRoleVO::getSysDataAuthVO).filter(Objects::nonNull).collect(Collectors.toList());
//            if (CollectionUtils.isNotEmpty(basicSysDataAuthVos)) {
//                if (isCodePath) {
//                    calculateAuthScope(userSupportDetailsDto, basicSysDataAuthVos, authScope);
//                } else {
//                    calculateAuthIds(userSupportDetailsDto, basicSysDataAuthVos, authScope);
//                }
//            }
//        }

        return authScope;
    }

    /**
     * 计算授权ID
     *
     * @param userEmpBuDto   用户绑定的员工和组织信息
     * @param sysDataAuthVos 授权列表
     * @param authScope      授权范围
     */
//    private static void calculateAuthIds(SecurityOrgUserEmpBuDTO userEmpBuDto, List<SysDataAuthVO> sysDataAuthVos, AuthScope authScope) {
//        // 是否全部组织
//        boolean isAllBu = false;
//        // 是否自己及以下
//        boolean isBuSelfChild = false;
//        // 是否自己
//        boolean isBuSelf = false;
//        // 是否全部员工
//        boolean isAllEmp = false;
//        // 是否自己及以下
//        boolean isEmpSelfChild = false;
//        // 是否自己
//        boolean isEmpSelf = false;
//
//        Set<Long> buIdSet = new HashSet<>();
//        Set<Long> empIdSet = new HashSet<>();
//        Set<Long> ouIdSet = new HashSet<>();
//        authScope.setBuIds(buIdSet);
//        authScope.setEmpIds(empIdSet);
//        authScope.setOuIds(ouIdSet);
//
//        for (SysDataAuthVO sysDataAuthVo : sysDataAuthVos) {
//
//            // 1. 只要有一个授权是全部授权，则直接清空所有数据，并且直接返回
//            if (sysDataAuthVo.getIsAll() != null && sysDataAuthVo.getIsAll()) {
//                buIdSet.clear();
//                empIdSet.clear();
//                ouIdSet.clear();
//                return;
//            }
//
//            // 2. 组合授权的组织ID
//            if (!isAllBu && sysDataAuthVo.getBuAuthEnable() != null && sysDataAuthVo.getBuAuthEnable()) {
//
//                // 2.1 判读组织授权方式，组合授权ID
//                if (sysDataAuthVo.getBuDataAuthScope() != null) {
//                    if (SysDataRoleAuthScope.ALL.name().equals(sysDataAuthVo.getBuDataAuthScope().name())) {
//                        // 第一优先级，判断是否全部，范围最大
//                        buIdSet.clear();
//                        isAllBu = true;
//
//                    } else if (!isBuSelfChild && SysDataRoleAuthScope.SELF_CHILDES.name().equals(sysDataAuthVo.getBuDataAuthScope().name())) {
//                        // 第二优先级，判断是否自己及以下，范围第二大，第一次进入之后，就不在进入
//                        isBuSelfChild = true;
//                        if (CollectionUtils.isNotEmpty(userEmpBuDto.getChildEmpBuIds())) {
//                            buIdSet.addAll(userEmpBuDto.getChildEmpBuIds());
//                        }
//
//                    } else if (!isBuSelfChild && !isBuSelf && SysDataRoleAuthScope.SELF.name().equals(sysDataAuthVo.getBuDataAuthScope().name())) {
//                        // 第三优先级，判断是否自己，范围最小，第一次进入之后，就不需要再进入
//                        isBuSelf = true;
//                        if (CollectionUtils.isNotEmpty(userEmpBuDto.getEmpBuIds())) {
//                            buIdSet.addAll(userEmpBuDto.getEmpBuIds());
//                        }
//                    }
//                }
//
//                // 2.2 组合自定义组织ID
//                if (!isAllBu && CollectionUtils.isNotEmpty(sysDataAuthVo.getBuIdSet())) {
//                    buIdSet.addAll(sysDataAuthVo.getBuIdSet());
//                }
//
//            }
//
//            // 3. 组合授权的员工ID
//            if (!isAllEmp && sysDataAuthVo.getEmpAuthEnable() != null && sysDataAuthVo.getEmpAuthEnable()) {
//
//                // 3.1 判断与阿农授权方式，组合授权ID
//                if (sysDataAuthVo.getUserDataAuthScope() != null) {
//                    if (SysDataRoleAuthScope.ALL.name().equals(sysDataAuthVo.getUserDataAuthScope().name())) {
//                        // 第一优先级，判断是否全部，范围最大
//                        empIdSet.clear();
//                        isAllEmp = true;
//
//                    } else if (!isEmpSelfChild && SysDataRoleAuthScope.SELF_CHILDES.name().equals(sysDataAuthVo.getUserDataAuthScope().name())) {
//                        // 第二优先级，判断是否自己及以下，范围第二大，第一次进入之后，就不在进入
//                        isEmpSelfChild = true;
//                        if (CollectionUtils.isNotEmpty(userEmpBuDto.getChildEmpIds())) {
//                            empIdSet.addAll(userEmpBuDto.getChildEmpIds());
//                        }
//
//                    } else if (!isEmpSelfChild && !isEmpSelf && SysDataRoleAuthScope.SELF.name().equals(sysDataAuthVo.getUserDataAuthScope().name())) {
//                        // 第三优先级，判断是否自己，范围最小，第一次进入之后，就不需要再进入
//                        isEmpSelf = true;
//                        if (userEmpBuDto.getEmpId() != null) {
//                            empIdSet.add(userEmpBuDto.getEmpId());
//                        }
//                    }
//                }
//
//                // 3.2 组合自定义组织ID
//                if (!isAllEmp && CollectionUtils.isNotEmpty(sysDataAuthVo.getUserIdSet())) {
//                    empIdSet.addAll(sysDataAuthVo.getUserIdSet());
//                }
//            }
//
//            // 4. 组合授权的公司ID
//            // 公司当前只做自定义
//            if (sysDataAuthVo.getOuAuthEnable() != null && sysDataAuthVo.getOuAuthEnable() && CollectionUtils.isNotEmpty(sysDataAuthVo.getOuIdSet())) {
//                ouIdSet.addAll(sysDataAuthVo.getOuIdSet());
//            }
//        }
//    }

    /**
     * 计算授权范围
     *
     * @param userEmpBuDto   用户绑定的员工和组织信息
     * @param sysDataAuthVos 授权列表
     * @param authScope      授权范围
     */
//    private static void calculateAuthScope(SecurityOrgUserEmpBuDTO userEmpBuDto, List<SysDataAuthVO> sysDataAuthVos, AuthScope authScope) {
//        // 是否全部组织
//        boolean isAllBu = false;
//        // 是否自己及以下
//        boolean isBuSelfChild = false;
//        // 是否自己
//        boolean isBuSelf = false;
//        // 是否全部员工
//        boolean isAllEmp = false;
//        // 是否自己及以下
//        boolean isEmpSelfChild = false;
//        // 是否自己
//        boolean isEmpSelf = false;
//
//        // 组织
//        Set<Long> buIdSet = new HashSet<>();
//        Set<String> buCodePath = new HashSet<>();
//        Set<Long> childBuIdSet = new HashSet<>();
//        Set<Long> customizedBuIdSet = new HashSet<>();
//
//        // 员工
//        Set<Long> empIdSet = new HashSet<>();
//        Set<String> empCodePath = new HashSet<>();
//        Set<Long> childEmpIdSet = new HashSet<>();
//        Set<Long> customizedEmpIdSet = new HashSet<>();
//
//        // 公司
//        Set<Long> ouIdSet = new HashSet<>();
//
//
//        authScope.setBuIds(buIdSet);
//        authScope.setBuCodePath(buCodePath);
//        authScope.setChildBuIds(childBuIdSet);
//        authScope.setCustomizedBuIds(customizedBuIdSet);
//        authScope.setEmpIds(empIdSet);
//        authScope.setEmpCodePath(empCodePath);
//        authScope.setChildEmpIds(childEmpIdSet);
//        authScope.setCustomizedEmpIds(customizedEmpIdSet);
//        authScope.setOuIds(ouIdSet);
//
//        for (SysDataAuthVO sysDataAuthVo : sysDataAuthVos) {
//
//            // 1. 只要有一个授权是全部授权，则直接清空所有数据直接返回
//            if (sysDataAuthVo.getIsAll() != null && sysDataAuthVo.getIsAll()) {
//                buIdSet.clear();
//                buCodePath.clear();
//                childBuIdSet.clear();
//                customizedBuIdSet.clear();
//
//                empIdSet.clear();
//                empCodePath.clear();
//                childEmpIdSet.clear();
//                customizedEmpIdSet.clear();
//
//                ouIdSet.clear();
//
//                return;
//            }
//
//            // 2. 组合授权的组织ID
//            if (!isAllBu && sysDataAuthVo.getBuAuthEnable() != null && sysDataAuthVo.getBuAuthEnable()) {
//
//                // 2.1 判读组织授权方式，组合授权ID
//                if (sysDataAuthVo.getBuDataAuthScope() != null) {
//                    if (SysDataRoleAuthScope.ALL.name().equals(sysDataAuthVo.getBuDataAuthScope().name())) {
//                        // 第一优先级，判断是否全部，范围最大
//                        buIdSet.clear();
//                        buCodePath.clear();
//                        childBuIdSet.clear();
//                        customizedBuIdSet.clear();
//                        isAllBu = true;
//
//                    } else if (!isBuSelfChild && SysDataRoleAuthScope.SELF_CHILDES.name().equals(sysDataAuthVo.getBuDataAuthScope().name())) {
//                        // 第二优先级，判断是否自己及以下，范围第二大，第一次进入之后，就不在进入
//                        isBuSelfChild = true;
//                        if (CollectionUtils.isNotEmpty(userEmpBuDto.getEmpBuCodePath()) && CollectionUtils.isNotEmpty(userEmpBuDto.getChildEmpBuIds())) {
//                            buIdSet.clear();
//                            buCodePath.addAll(userEmpBuDto.getEmpBuCodePath());
//                            childBuIdSet.addAll(userEmpBuDto.getChildEmpBuIds());
//                        }
//
//                    } else if (!isBuSelfChild && !isBuSelf && SysDataRoleAuthScope.SELF.name().equals(sysDataAuthVo.getBuDataAuthScope().name())) {
//                        // 第三优先级，判断是否自己，范围最小，第一次进入之后，就不需要再进入
//                        isBuSelf = true;
//                        if (CollectionUtils.isNotEmpty(userEmpBuDto.getEmpBuIds())) {
//                            buIdSet.addAll(userEmpBuDto.getEmpBuIds());
//                        }
//
//                    }
//                }
//
//                // 2.2 组合自定义组织ID
//                if (!isAllBu && CollectionUtils.isNotEmpty(sysDataAuthVo.getBuIdSet())) {
//                    customizedBuIdSet.addAll(sysDataAuthVo.getBuIdSet());
//                }
//
//            }
//
//            // 3. 组合授权的员工ID
//            if (!isAllEmp && sysDataAuthVo.getEmpAuthEnable() != null && sysDataAuthVo.getEmpAuthEnable()) {
//
//                // 3.1 判断员工授权方式，组合授权ID
//                if (sysDataAuthVo.getUserDataAuthScope() != null) {
//                    if (SysDataRoleAuthScope.ALL.name().equals(sysDataAuthVo.getUserDataAuthScope().name())) {
//                        // 第一优先级，判断是否全部，范围最大
//                        empIdSet.clear();
//                        empCodePath.clear();
//                        childEmpIdSet.clear();
//                        customizedEmpIdSet.clear();
//                        isAllEmp = true;
//
//                    } else if (!isEmpSelfChild && SysDataRoleAuthScope.SELF_CHILDES.name().equals(sysDataAuthVo.getUserDataAuthScope().name())) {
//                        // 第二优先级，判断是否自己及以下，范围第二大，第一次进入之后，就不在进入
//                        isEmpSelf = true;
//                        if (StringUtils.isNotBlank(userEmpBuDto.getEmpCodePath()) && CollectionUtils.isNotEmpty(userEmpBuDto.getChildEmpIds())) {
//                            empIdSet.clear();
//                            empCodePath.add(userEmpBuDto.getEmpCodePath());
//                            childEmpIdSet.addAll(userEmpBuDto.getChildEmpIds());
//                        }
//
//                    } else if (!isEmpSelfChild && !isEmpSelf && SysDataRoleAuthScope.SELF.name().equals(sysDataAuthVo.getUserDataAuthScope().name())) {
//                        // 第三优先级，判断是否自己，范围最小，第一次进入之后，就不需要再进入
//                        isEmpSelfChild = true;
//                        if (userEmpBuDto.getEmpId() != null) {
//                            empIdSet.add(userEmpBuDto.getEmpId());
//                        }
//
//                    }
//                }
//
//                // 3.2 组合自定义组织ID
//                if (!isAllEmp && CollectionUtils.isNotEmpty(sysDataAuthVo.getUserIdSet())) {
//                    customizedEmpIdSet.addAll(sysDataAuthVo.getUserIdSet());
//                }
//            }
//
//            // 4. 组合公司授权
//            if (sysDataAuthVo.getOuAuthEnable() != null && sysDataAuthVo.getOuAuthEnable() && CollectionUtils.isNotEmpty(sysDataAuthVo.getOuIdSet())) {
//                ouIdSet.addAll(sysDataAuthVo.getOuIdSet());
//            }
//        }
//    }
//

    /**
     * 私有方法 获取前端应用传递来的应用名称
     *
     * @return route 编号
     */
    private static String getRequestSysDataRoute() {
        if (RequestContextHolder.getRequestAttributes() == null) {
            return null;
        } else {
            HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();

            return request.getHeader(ROUTE_KEY);
        }
    }

    static void setDataPermissionEnable(boolean dataPermissionEnable) {
        DataAuthJpaUtil.dataPermissionEnable = dataPermissionEnable;
    }

    /***测试使用。  用于没有登录用户的API 开发时测试使用。 **/
//    public static Predicate testDataAuthJpaPredicate(PathMetadata metadata) throws Exception {
//        SysDataAuthVO sysDataAuthVO = getTestSysDataPermissionVO();
//        return buildIdInPredicate(new QBaseModel(metadata), SecurityContextUtil.currentUser(), sysDataAuthVO);
//    }
//
//    //测试方法 生成模拟数据角色和相关权限数据
//    protected static SysDataAuthVO getTestSysDataPermissionVO() {
//        Set<Long> bulist = new HashSet<>();
//        Set<Long> userlist = new HashSet<>();
//        int shu = 300;
//        for (Long i = 1L; i < shu; i++) {
//            bulist.add(i);
//            userlist.add(i);
//        }
//        SysDataAuthVO sysDataAuthVO = new SysDataAuthVO();
//        sysDataAuthVO.setBuIdSet(bulist);
//        sysDataAuthVO.setUserIdSet(userlist);
//        return sysDataAuthVO;
//    }


}
