package com.elitescloud.boot.datasecurity.dataauth.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.constant.IdGeneratorStrategy;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Objects;

/**
 * 员工与组织树关联
 *
 * @author Chris
 * @date 2021-03-29
 * @deprecated 用于1.0的数据权限，已遗弃
 */
//@Entity
@Table(name = "common_org_emp", indexes = {
        @Index(name = "idx_emp_pid", columnList = "pid"),
        @Index(name = "idx_emp_code_path", columnList = "codePath")
})
@org.hibernate.annotations.Table(appliesTo = "common_org_emp", comment = "员工")
@Data
@DynamicInsert
@DynamicUpdate
@Where(clause = "delete_flag = 0 or delete_flag is null")
@Accessors(chain = true)
@ApiModel(value = "员工", description = "员工")
@Deprecated
public class SecOrgEmpDO implements Serializable {

    private static final long serialVersionUID = -2626035008851252416L;

    @Id
    @GenericGenerator(name = "el-id", strategy = IdGeneratorStrategy.DEFAULT)
    @GeneratedValue(strategy = GenerationType.AUTO, generator = "el-id")
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("记录唯一ID")
    @Comment("记录唯一ID")
    @Column()
    private Long id;

    /**
     * 上级ID
     */
    @ApiModelProperty(value = "上级ID")
    @Comment("上级ID")
    @Column()
    private Long pid = 0L;

    /**
     * 排序号
     */
    @ApiModelProperty(value = "排序号")
    @Comment("排序号")
    @Column()
    private Integer sortNo;

    /**
     * 层级
     */
    @ApiModelProperty(value = "层级")
    @Comment("层级")
    @Column()
    private Integer level = 1;

    /**
     * 树型结构编号全路径，使用/隔离
     */
    @ApiModelProperty("树型结构编号全路径，使用/隔离")
    @Comment("树型结构编号全路径，使用/隔离")
    @Column()
    private String codePath;

    /**
     * 用户id
     */
    @ApiModelProperty(value = "用户id")
    @Comment("用户id")
    @Column
    private Long userId;

    /**
     * 用户名
     */
    @ApiModelProperty(value = "用户名")
    @Comment("用户名")
    @Column()
    private String userName;

    /**
     * 雇员编号
     */
    @ApiModelProperty(value = "雇员编号")
    @Comment("雇员编号")
    @Column()
    private String empCode;

    /**
     * 雇员姓名
     */
    @ApiModelProperty(value = "雇员姓名")
    @Comment("雇员姓名")
    @Column()
    private String empName;

    /**
     * 逻辑删除，0：未删除，1：已删除
     */
    @ApiModelProperty(value = "逻辑删除，0：未删除，1：已删除")
    @Comment("逻辑删除，0：未删除，1：已删除")
    @Column
    private Integer deleteFlag;


    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SecOrgEmpDO)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SecOrgEmpDO entity = (SecOrgEmpDO) o;
        return getId().equals(entity.getId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getId());
    }
}
