package com.elitescloud.boot.datasecurity.common;

import cn.hutool.core.lang.Assert;
import cn.hutool.db.sql.Condition;
import cn.hutool.db.sql.ConditionBuilder;
import cn.zhxu.bs.param.OrderBy;
import cn.zhxu.bs.util.MapBuilder;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import org.springframework.util.CollectionUtils;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author : chen.niu
 * @description :
 * @date : 2023/5/26 20:55
 */
public class BeanSearcherUtils {
    /***
     * 动态排序私有方法
     * todo未来转成公共
     * @param orders 前端排序入参
     * @param mapBuilder 构造器
     * @param defaultOrder 如果前端没有传参，默认排序参数
     */
    public static void setParamsOrderBy(List<OrderItem>
                                                orders, MapBuilder mapBuilder, OrderBy defaultOrder) {
        Assert.notNull(defaultOrder,"默认排序不能空");
        if(orders==null){
            mapBuilder.orderBy(defaultOrder.getSort(), defaultOrder.getOrder());
            return;
        }
        for (OrderItem orderItem : orders) {
            if (orderItem != null && !orderItem.getColumn().isBlank()) {
                if (orderItem.isAsc()) {
                    mapBuilder.orderBy(orderItem.getColumn()).asc();
                }
                else {
                    mapBuilder.orderBy(orderItem.getColumn()).desc();
                }
            } else {
                mapBuilder.orderBy(defaultOrder.getSort(), defaultOrder.getOrder());
            }
        }
    }

    public static String generateCondition(String field, String operator, Object value) {
        String formattedValue;

        if (value instanceof String) {
            formattedValue = "'" + value + "'";
        } else if (value instanceof Number) {
            formattedValue = value.toString();
        } else if ("in".equalsIgnoreCase(operator) && value instanceof Collection) {
            Collection<?> values = (Collection<?>) value;

            if (values.isEmpty()) {
                return "";
            }

            Object firstValue = values.iterator().next();

            if (firstValue instanceof String) {
                formattedValue = values.stream()
                        .map(v -> "'" + v + "'")
                        .collect(Collectors.joining(","));
            } else {
                formattedValue = values.stream()
                        .map(Object::toString)
                        .collect(Collectors.joining(","));
            }

            return "and " + field + " in (" + formattedValue + ")";
        } else {
            formattedValue = value.toString();
        }

        return String.format("and %s %s %s", field, operator, formattedValue);
    }

    //    public static void main(String[] args) {
//        String condition1 = generateCondition("sd.barcode", "=", "2000000014183");
//        System.out.println(condition1);  // 输出：and sd.barcode = '2000000014183'
//
//        String condition2 = generateCondition("sd.quantity", "=", 100);
//        System.out.println(condition2);  // 输出：and sd.quantity = 100
//
//        String condition3 = generateCondition("sd.barcode", "in", List.of("2000000014183", "2000000014184"));
//        System.out.println(condition3);  // 输出：and sd.barcode in ('2000000014183','2000000014184')
//
//        String condition4 = generateCondition("sd.quantity", "in", List.of(100, 200));
//        System.out.println(condition4);  // 输出：and sd.quantity in (100,200)
//    }
    public  static class Operator {
        public static final String OPERATOR_LIKE = "LIKE";
        public static final String OPERATOR_IN = "IN";
        public static final String OPERATOR_IS = "IS";
        public static final String OPERATOR_IS_NOT = "IS NOT";
        public static final String OPERATOR_BETWEEN = "BETWEEN";
        public static final List<String> OPERATORS = Arrays.asList("<>", "<=", "<", ">=", ">", "=", "!=", OPERATOR_IN);

    }


    public static String convertListNumberToString(List<Long> list) {
        if (list != null && !list.isEmpty()) {
            return list.stream()
                    .map(String::valueOf)
                    .collect(Collectors.joining(","));
        }
        return "";
    }
    public static String convertListStringToString(List<String> list) {
        if (list != null && !list.isEmpty()) {

            String result = list.stream()
                    .map(num -> "'" + num + "'")
                    .collect(Collectors.joining(","));
            return result;
        }
        return "";
    }
}
