package com.elitescloud.boot.datasecurity.config;

import cn.zhxu.bs.BeanSearcher;
import cn.zhxu.bs.MapSearcher;
import com.elitescloud.boot.datasecurity.dpr.beansearcher.BeanSearcherFactory;
import com.elitescloud.boot.datasecurity.dpr.beansearcher.BeanSearcherPermissionRuleService;
import com.elitescloud.boot.datasecurity.dpr.beansearcher.BeanSearcherPermissionRuleServiceImpl;
import com.elitescloud.boot.datasecurity.dpr.service.RoleDataPermissionRuleService;
import com.elitescloud.boot.provider.TenantClientProvider;
import org.springframework.context.annotation.Bean;

/**
 * beansearch相关服务类.
 *
 * @author Kaiser（wang shao）
 * @date 2023/4/8
 */
public class DataSecurityBeanSearchConfig {

    @Bean
    public BeanSearcherPermissionRuleService beanSearcherPermissionRuleService(  RoleDataPermissionRuleService dataPermissionRuleService) {
        return new BeanSearcherPermissionRuleServiceImpl(dataPermissionRuleService);
    }

    @Bean
    public BeanSearcherFactory beanSearcherFactory(BeanSearcher beanSearcher,
                                                   MapSearcher mapSearcher,
                                                   TenantClientProvider tenantClientProvider,
                                                   BeanSearcherPermissionRuleService beanSearcherPermissionRuleService) {
        return new BeanSearcherFactory(beanSearcher, mapSearcher, tenantClientProvider, beanSearcherPermissionRuleService);
    }



}
