package com.elitescloud.boot.datasecurity.jpa.strategy.longStrategy;

import com.elitescloud.boot.datasecurity.jpa.strategy.RuleStrategy;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.core.types.dsl.PathBuilder;

/**
 * @author : chen.niu
 * @description :
 * @date : 2023/10/14 17:20
 */
public class LongEqualStrategy implements RuleStrategy {

    @Override
    public Predicate applyRule(PathBuilder<?> entityPath, String fieldName, String ruleValue) {
        NumberPath<Long> path = entityPath.getNumber(fieldName, Long.class);
        Long value = Long.parseLong(ruleValue);
        return path.eq(value);
    }
}