/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.datasecurity.dpr.beansearcher;

import cn.zhxu.bs.util.MapBuilder;
import cn.zhxu.bs.util.MapUtils;
import com.elitescloud.boot.datasecurity.dpr.beansearcher.BeanSearcherPermissionRuleService;
import com.elitescloud.boot.datasecurity.dpr.content.DprRuleValueTypeEnum;
import com.elitescloud.boot.datasecurity.dpr.service.RoleDataPermissionRuleService;
import com.elitescloud.boot.datasecurity.dpr.service.util.AnnotationUtil;
import com.elitescloud.boot.datasecurity.dpr.service.util.DataPermissionRuleServiceUtil;
import com.elitescloud.boot.datasecurity.dpr.service.util.RoleDatePermissionColumnUtil;
import com.elitescloud.boot.datasecurity.dpr.service.util.RoleDatePermissionRowUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.cloudt.system.dto.SysDpcRoleApiFieldsDTO;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiDataRuleListQueryDTO;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiRowColumnRuleDTO;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class BeanSearcherPermissionRuleServiceImpl
implements BeanSearcherPermissionRuleService {
    private static final Logger log = LoggerFactory.getLogger(BeanSearcherPermissionRuleServiceImpl.class);
    @Autowired
    private TenantClientProvider tenantClientProvider;
    private final RoleDataPermissionRuleService roleDataPermissionRuleService;

    public BeanSearcherPermissionRuleServiceImpl(RoleDataPermissionRuleService roleDataPermissionRuleService) {
        this.roleDataPermissionRuleService = roleDataPermissionRuleService;
    }

    @Override
    public SysDprRoleApiRowColumnRuleDTO getUserRoleDpr() {
        return this.roleDataPermissionRuleService.getUserRoleDpr();
    }

    @Override
    public String getBeanSearcherGroupExpr(Map<String, Object> params) {
        return RoleDatePermissionColumnUtil.getBeanSearcherGroupExpr(params);
    }

    @Override
    public void addSetBeanSearcherGroupExpr(Map<String, Object> params, String groupExpr) {
        RoleDatePermissionColumnUtil.addSetBeanSearcherGroupExpr(params, groupExpr);
    }

    @Override
    public MapBuilder tenantAuthSearcherHandleEngine(Class<?> classBean, Map<String, Object> params, String ... pathObj) {
        SysDprRoleApiRowColumnRuleDTO roelDprDto = this.getUserRoleDpr();
        StringBuilder groupAuthExpr = new StringBuilder();
        MapBuilder mapBuilder = MapUtils.builder(params);
        StringBuilder groupTenantExpr = new StringBuilder(RoleDatePermissionColumnUtil.tenantAuthBuilder(this.tenantClientProvider, mapBuilder, params));
        List<SysDprRoleApiDataRuleListQueryDTO> startDto = RoleDatePermissionColumnUtil.apiPathRoleApiRowsRuleGroupDtoHandle(pathObj, roelDprDto);
        Field[] fields = AnnotationUtil.getAllFields(classBean);
        if (!startDto.isEmpty()) {
            for (SysDprRoleApiDataRuleListQueryDTO sdto : startDto) {
                boolean ifField = false;
                for (Field field : fields) {
                    if (!field.getName().equals(sdto.getDprRuleField())) continue;
                    ifField = true;
                    break;
                }
                if (ifField) continue;
                throw new BusinessException("\u5f02\u5e38\uff1a\u5bf9\u5e94\u7684\u89c4\u5219\u5b57\u6bb5\u5728bean\u4e2d\u4e0d\u5b58\u5728-" + sdto.getDprRuleField());
            }
            StringBuilder ruleGroupExpr = this.ruleAuthBuilder(mapBuilder, startDto);
            if (ruleGroupExpr.length() > 0) {
                groupAuthExpr = groupTenantExpr.append("&").append((CharSequence)ruleGroupExpr);
            }
        } else {
            groupAuthExpr = groupTenantExpr;
        }
        if (groupAuthExpr.length() <= 0) {
            throw new RuntimeException("\u6570\u636e\u6743\u9650\u5206\u7ec4\u8868\u8fbe\u5f0f groupAuthExpr is null  ");
        }
        mapBuilder.groupExpr(groupAuthExpr.toString());
        List<SysDpcRoleApiFieldsDTO> columnDto = RoleDatePermissionRowUtil.apiPathRoleApiColumnRuleGroupDtoHandle(pathObj, roelDprDto);
        if (columnDto != null && columnDto.size() > 0) {
            RoleDatePermissionColumnUtil.setColumnMapBuilder(fields, columnDto, mapBuilder);
        }
        return mapBuilder;
    }

    @Override
    public StringBuilder ruleAuthBuilder(MapBuilder mapBuilder, List<SysDprRoleApiDataRuleListQueryDTO> ruleList) {
        StringBuilder groupExpr = new StringBuilder();
        Map<Long, List<SysDprRoleApiDataRuleListQueryDTO>> groupBy = ruleList.stream().collect(Collectors.groupingBy(SysDprRoleApiDataRuleListQueryDTO::getRoleId));
        int groupStrIndex = 0;
        int groupMapIndex = 0;
        for (Long key : groupBy.keySet()) {
            List<SysDprRoleApiDataRuleListQueryDTO> v = groupBy.get(key);
            Collections.sort(v, Comparator.comparing(SysDprRoleApiDataRuleListQueryDTO::getRuleOrder));
            for (int i = 0; i < v.size(); ++i) {
                SysDprRoleApiDataRuleListQueryDTO rule = v.get(i);
                String gStr = RoleDatePermissionColumnUtil.GROUP_STR[groupStrIndex++];
                mapBuilder.group(gStr);
                RoleDatePermissionColumnUtil.jointGroupExpr(i, v.size(), rule, gStr, groupExpr);
                String valueType = rule.getDprRuleValueType();
                if (valueType.equals(DprRuleValueTypeEnum.DPR_RULE_VALUE_TYPE_CUSTOM.name()) || valueType.equals(DprRuleValueTypeEnum.DPR_RULE_VALUE_TYPE_SYS.name()) || valueType.equals(DprRuleValueTypeEnum.DPR_RULE_VALUE_TYPE_BUSINESS.name())) {
                    DataPermissionRuleServiceUtil.dprRuleValueTypeMapBuilder(mapBuilder, rule);
                    continue;
                }
                DataPermissionRuleServiceUtil.throwRuntimeException("\u975e\u6cd5\u7684value-type\u7c7b\u578b\uff0c\u8bf7\u5c3d\u5feb\u8054\u7cfb\u7ba1\u7406\u5458\u3002\uff1a", rule);
            }
            if (++groupMapIndex >= groupBy.size()) continue;
            groupExpr.append("|");
        }
        groupExpr.insert(0, "(");
        groupExpr.append(")");
        return groupExpr;
    }

    @Override
    public MapBuilder tenantSearcherHandleEngine(Class<?> beanClass, Map<String, Object> paraMap, String ... pathObj) {
        MapBuilder mapBuilder = MapUtils.builder(paraMap);
        StringBuilder groupExpr = new StringBuilder(RoleDatePermissionColumnUtil.tenantBuilder(this.tenantClientProvider, mapBuilder, paraMap));
        return mapBuilder;
    }
}

