package com.elitescloud.boot.datasecurity.config;

import com.elitescloud.boot.datasecurity.dpr.service.RoleDataPermissionRuleService;
import com.elitescloud.boot.datasecurity.jpa.strategy.RoleRuleJpaService;
import com.elitescloud.boot.security.config.CustomSecurityProperties;
import com.elitescloud.cloudt.core.security.util.DataAuthJpaUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.annotation.Bean;

/**
 * 数据权限配置.
 *
 * @author Kaiser（wang shao）
 * @date 2022/8/2
 */
public class DataSecurityJpaConfig implements InitializingBean {

    private final CustomSecurityProperties securityProperties;

    public DataSecurityJpaConfig(CustomSecurityProperties securityProperties) {
        this.securityProperties = securityProperties;
    }

    @Bean
    public RoleRuleJpaService roleRuleJpaService(RoleDataPermissionRuleService roleDataPermissionRuleService) {
        return new RoleRuleJpaService(roleDataPermissionRuleService);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        DataAuthJpaUtil.setDataPermissionEnable(securityProperties.getPermissionDataEnabled());
    }
}
