package com.elitescloud.boot.datasecurity.dpr.content;


import com.elitescloud.cloudt.system.vo.DprUdcVO;

import java.util.ArrayList;
import java.util.List;

/**
 * 规则条件
 *  根据bean searcher的  FieldOps的枚举 命名
 * @author chen
 **/
public enum DprRuleConditionEnum implements BasicUdcEnumInterface {

    /*** 规则*/
   Equal("SYSTEM", "DPR_RULE_CONDITION", "规则条件", "等于", 1),
   NotEqual("SYSTEM", "DPR_RULE_CONDITION", "规则条件", "不等", 2),
   GreaterEqual("SYSTEM", "DPR_RULE_CONDITION", "规则条件", "大于等于", 3),
   GreaterThan("SYSTEM", "DPR_RULE_CONDITION", "规则条件", "大于", 4),
   LessEqual("SYSTEM", "DPR_RULE_CONDITION", "规则条件", "小于等于", 5),
   LessThan("SYSTEM", "DPR_RULE_CONDITION", "规则条件", "小于", 6),
   Contain("SYSTEM", "DPR_RULE_CONDITION", "规则条件", "包含  like '%xxx%'", 11),
   StartWith("SYSTEM", "DPR_RULE_CONDITION", "规则条件", "以 .. 开始*like 'xxx%'", 12),
   EndWith("SYSTEM", "DPR_RULE_CONDITION", "规则条件", "结束 like '%xxx'", 13),
   Between("SYSTEM", "DPR_RULE_CONDITION", "规则条件", "在 .. 和 .. 之间", 14),
   NotBetween("SYSTEM", "DPR_RULE_CONDITION", "规则条件", "不在 .. 和 .. 之间", 15),
   InList("SYSTEM", "DPR_RULE_CONDITION", "规则条件", " 在列表中 in", 16),
   NotIn("SYSTEM", "DPR_RULE_CONDITION", "规则条件", "不在某个集合内 not in", 17),
    //   IsNull("SYSTEM", "DPR_RULE_CONDITION", "规则条件", "为 null", 7),
//   NotNull("SYSTEM", "DPR_RULE_CONDITION", "规则条件", " 不为 null", 8),
//   Empty("SYSTEM", "DPR_RULE_CONDITION", "规则条件", "为空", 9),
//   NotEmpty("SYSTEM", "DPR_RULE_CONDITION", "规则条件", "不为空", 10),
    ;

    /*** 应用编码*/
    private final String domainCode;
    /*** 枚举/udc的大类 */
    private final String udcCode;
    /*** 枚举.udc的大类名称*/
    private final String udcName;
    /*** 当前枚举值字符串的描述*/
    private final String valueDescription;
    /*** 排序*/
    private final int sortNo;


    private final DprUdcVO sysUdcVO;

    DprRuleConditionEnum(String domainCode, String udcCode,
                         String udcName, String description,
                         int sortNo
    ) {

        this.domainCode = domainCode;
        this.sortNo = sortNo;
        this.udcCode = udcCode;
        this.udcName = udcName;
        this.valueDescription = description;
        this.sysUdcVO = this.newUdcVo(domainCode, udcCode, udcName, description, sortNo, this.name());
    }

    @Override
    public DprUdcVO getUdcVO() {
        return this.sysUdcVO;
    }

    @Override
    public String getValueDescription() {
        return valueDescription;
    }

    public static String getValue(String key) {
        for (var ele : values()) {
            if (ele.name().equals(key)) {
                return ele.getValueDescription();
            }
        }
        return null;
    }
    public static List<DprUdcVO> getSysUdcVOList() {
        ArrayList<DprUdcVO> sysUdcVOList = new ArrayList<>();
        for (var ele : values()) {
            sysUdcVOList.add(ele.getUdcVO());
        }
        return sysUdcVOList;
    }
}
