package com.elitescloud.boot.datasecurity.dpr.service;

import com.elitescloud.cloudt.system.dto.SysDprRoleApiRowColumnRuleDTO;

import java.util.Optional;

/**
 * 当前账号角色的数据权限信息的缓存与读取
 * @author : chen
 * @date 2022-11-25 09:46
 */
public interface RoleDataPermissionRuleCacheInterface {

    /**
     * 读取当前账号角色的数据权限规则信息 远程调用system域接口获取。
     * @param token 令牌
     * @return 数据权限规则组和规则
     *
     */
    SysDprRoleApiRowColumnRuleDTO roleDataPermissionRuleRpc(String token);


    /**
     * 本地化缓存账号的数据权限信息
     *
     * @param roleRuleGroupDtoList 数据权限规则组和规则
     * @param token                令牌
     */
    void tokenDprLocalCacheSave(String token,
                                SysDprRoleApiRowColumnRuleDTO roleRuleGroupDtoList);

    /**
     * redis缓存账号的数据权限信息
     * @param roleRuleGroupDtoList 数据权限规则组和规则
     * @param token 令牌
     * @return 成功失败
     */
    Boolean tokenRedisCacheSave(String token, SysDprRoleApiRowColumnRuleDTO roleRuleGroupDtoList);


    /**
     *  读取本地化的缓存的数据权限信息。
     * @param token token
     * @return 如果都没有返回null，有则返回
     *
     */
    Optional<SysDprRoleApiRowColumnRuleDTO> getTokenDprLocalCache(String token);

    /**
     *  读取redis的缓存的数据权限信息。
     * @param token token
     * @return 如果都没有返回null，有则返回
     *
     */
    Optional<SysDprRoleApiRowColumnRuleDTO> getTokenDprRedisCache(String token);
}
