package com.elitescloud.boot.datasecurity.dpr.service.impl;//package com.elitescloud.cloudt.core.dpr.service.impl;
//
//import cn.hutool.core.collection.ListUtil;
//import cn.zhxu.bs.param.Operator;
//import cn.zhxu.bs.util.MapBuilder;
//import cn.zhxu.bs.util.MapUtils;
//import com.elitescloud.cloudt.authorization.core.SecurityContextUtil;
//import com.elitescloud.cloudt.common.base.BaseModel;
//import com.elitescloud.cloudt.common.exception.BusinessException;
//import com.elitescloud.cloudt.context.util.HttpServletUtil;
//import com.elitescloud.cloudt.core.dpr.content.DprRuleRelationEnum;
//import com.elitescloud.cloudt.core.dpr.content.DprRuleValueTypeEnum;
//import com.elitescloud.cloudt.core.dpr.service.DataPermissionRuleService;
//import com.elitescloud.cloudt.core.dpr.service.RoleDataPermissionRuleCacheInterface;
//import com.elitescloud.cloudt.core.dpr.service.util.DataPermissionRuleServiceUtil;
//import com.elitescloud.cloudt.system.dto.SysDprRoleApiRuleGroupDTO;
//import com.elitescloud.cloudt.system.dto.SysDprRoleApiRuleGroupRuleDTO;
//import lombok.extern.slf4j.Slf4j;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.stereotype.Service;
//
//import javax.servlet.http.HttpServletRequest;
//import java.util.ArrayList;
//import java.util.List;
//import java.util.Map;
//import java.util.stream.Collectors;
//
///**
// * 数据权限规则解析接口  需要bean Searcher和jpa分别实现。
// *
// * @author : chen
// * @date 2022-11-24 14:12
// */
//@Slf4j
//public class DataPermissionRuleServiceImpl implements DataPermissionRuleService {
//    @Autowired
//    private com.elitescloud.cloudt.core.tenant.support.TenantClientProvider tenantClientProvider;
//
//    private final RoleDataPermissionRuleCacheInterface roleDataPermissionRuleCacheInterface;
//    private final static String[] GROUP_STR = new String[]{"DPRaa", "DPRbb", "DPRcc"
//            , "DPRdd", "DPRee", "DPRff", "DPRgg", "DPRhh", "DPRii", "DPRjj", "DPRkk",
//            "DPRll", "DPRmm", "DPRnn", "DPRoo", "DPRpp", "DPRqq", "DPRrr", "DPRss", "DPRtt", "DPRuu"
//            , "DPRvv", "DPRww", "DPRxx", "DPRyy", "DPRzz"};
//    private final static String SB_MAP_GROUP_EXPR = "com.ejlchina.searcher.SearchParam.GROUP_EXPR";
//
//    public DataPermissionRuleServiceImpl(RoleDataPermissionRuleCacheInterface roleDataPermissionRuleCacheInterface) {
//        this.roleDataPermissionRuleCacheInterface = roleDataPermissionRuleCacheInterface;
//    }
//
//    @Override
//    public List<SysDprRoleApiRuleGroupDTO> getUserRoleDpr() {
//        var token = SecurityContextUtil.currentToken();
//        if (token == null || "".equals(token)) {
//            log.error("数据权限：获取Token为空 ");
//            return ListUtil.empty();
//        }
//        return roleDataPermissionRuleCacheInterface.getTokenDprLocalCache(token)
//                .orElseGet(() -> roleDataPermissionRuleCacheInterface.getTokenDprRedisCache(token)
//                        .orElseGet(() -> roleDataPermissionRuleCacheInterface.roleDataPermissionRuleRpc(token)));
//    }
//
//    @Override
//    public String getBeanSearcherGroupExpr(Map<String, Object> params) {
//        return params.get(SB_MAP_GROUP_EXPR) != null ? params.get(SB_MAP_GROUP_EXPR).toString() : null;
//
//    }
//
//    @Override
//    public void addSetBeanSearcherGroupExpr(Map<String, Object> params, String groupExpr) {
//        Object drpGroupExpr = params.get(SB_MAP_GROUP_EXPR);
//        params.put(SB_MAP_GROUP_EXPR, drpGroupExpr + groupExpr);
//    }
//
//    @Override
//    public MapBuilder tenantAuthSearcherHandleEngine(Class<?> classBean,
//                                                     Map<String, Object> params,
//                                                     String... pathObj) {
//
//        //根据请求的path路径  比对当前用户全部的api数据权限配置。 找到对应的api数据权限配置规则组和规则信息并返回
//        List<SysDprRoleApiRuleGroupDTO> startDto = apiPathRoleApiRuleGroupDtoHandle(pathObj);
//        MapBuilder mapBuilder = MapUtils.builder(params);
//        if (startDto.isEmpty()) {
//            return mapBuilder;
//        }
//        //根据原SQL的条件分组关系+租户条件分组关系表达式，构建一个新的分组关系字符串给规则分组表达式使用
//        StringBuilder groupExpr = new StringBuilder(tenantBuilder(mapBuilder, params));
////        Map<String, List<SysDprRoleApiRuleGroupRuleDTO>> ruleFieldMap = new HashMap<>();
//        List<SysDprRoleApiRuleGroupRuleDTO> ruleList = new ArrayList<>();
//        for (SysDprRoleApiRuleGroupDTO ruleGroup : startDto) {
//            if (!ruleGroup.getRules().isEmpty()) {
//                for (SysDprRoleApiRuleGroupRuleDTO rule : ruleGroup.getRules()) {
//                    if (rule.getDprRuleValue() == null || "".equals(rule.getDprRuleValue())) {
//                        log.error("规则值空，请尽快联系管理员。此规则将跳过：{}", rule);
//                        continue;
//                    }
//                    ruleList.add(rule);
//                }
//            }
//        }
//        //根据规则构造行数据权限条件
//        ruleAuthBuilder(mapBuilder,groupExpr,ruleList);
//
//        //设置分组条件表达式
//        mapBuilder.groupExpr(groupExpr.toString());
//        return mapBuilder;
//    }
//
//    /**根据规则构造行数据权限条件**/
//    @Override
//    public  void ruleAuthBuilder(MapBuilder mapBuilder, StringBuilder groupExpr, List<SysDprRoleApiRuleGroupRuleDTO> ruleList) {
//        for (int i = 0; i < ruleList.size(); i++) {
//            var rule = ruleList.get(i);
//            //beanSearcher的分组关系设置。  由于同一个字段，不同条件的or
//            String gStr = GROUP_STR[i];
//            //设置分组
//            mapBuilder.group(gStr);
//
//            //拼接BS的分组条件 groupExpr直接拼接
//            jointGroupExpr(i, ruleList.size(), rule, gStr, groupExpr);
//
//            String valueType = rule.getDprRuleValueType();
//            //目前规则值都已经在第一次远程调用接口的时候计算好了。所以各类型的判断暂时无用。都采用同一个方法处理。
//            //固定值类型值设置  //自定义类型值设置  和固定值一样 //系统内置
//            if (valueType.equals(DprRuleValueTypeEnum.DPR_RULE_VALUE_TYPE_FIXED.name())
//                    || valueType.equals(DprRuleValueTypeEnum.DPR_RULE_VALUE_TYPE_CUSTOM.name())
//                    || valueType.equals(DprRuleValueTypeEnum.DPR_RULE_VALUE_TYPE_SYS.name())) {
//                DataPermissionRuleServiceUtil.dprRuleValueTypeMapBuilder(mapBuilder, rule);
//            } else {
//                DataPermissionRuleServiceUtil.throwRuntimeException("非法的value-type类型，请尽快联系管理员。：", rule);
//            }
//        }
//    }
//
//    @Override
//    public MapBuilder tenantSearcherHandleEngine(Class<?> beanClass, Map<String, Object> paraMap, String... pathObj) {
//        //根据请求的path路径  比对当前用户全部的api数据权限配置。 找到对应的api数据权限配置规则组和规则信息并返回
//        MapBuilder mapBuilder = MapUtils.builder(paraMap);
//        //根据原SQL的条件分组关系+租户条件分组关系表达式，构建一个新的分组关系字符串给规则分组表达式使用
//        StringBuilder groupExpr = new StringBuilder(tenantBuilder(mapBuilder, paraMap));
//        mapBuilder.groupExpr(groupExpr.toString());
//        return mapBuilder;
//    }
//
//    /***
//     * 根据原SQL的条件分组关系+租户条件分组关系表达式，构建一个新的分组关系字符串给规则分组表达式使用
//     * @param mapBuilder 新构造器
//     * @param params 原始sql的参数
//     * @return 拼接后的表达式
//     */
//    private String tenantBuilder(MapBuilder mapBuilder, Map<String, Object> params) {
//        var userInfo = SecurityContextUtil.currentUser();
//        Long tenantId = -1L;
//        //如果开启多租户
//        if (tenantClientProvider.enabledTenant()) {
//            if (userInfo != null && userInfo.getTenantId() != null) {
//                tenantId = userInfo.getTenantId();
//            } else {
//                throw new BusinessException("BS租户权限判断异常：userInfo 或 userInfo.getTenantId为空");
//            }
//        }
//        mapBuilder.group("tenantIdGroup");
//        mapBuilder.field(BaseModel::getTenantId, tenantId).op(Operator.Equal);
//        String bsGroupExpr = getBeanSearcherGroupExpr(params);
//        StringBuffer groupExpr = new StringBuffer();
//        //如果原始bs已经分组，需要追加分组
//        if (bsGroupExpr != null && bsGroupExpr.length() > 0) {
//            groupExpr.append(bsGroupExpr).append("&tenantIdGroup");
//        } else {
//            groupExpr.append("tenantIdGroup");
//        }
//        return groupExpr.toString();
//    }
//
//    private void jointGroupExpr(int i, int size, SysDprRoleApiRuleGroupRuleDTO rule, String gStr, StringBuilder groupExpr) {
//        if (size == 0) {
//            return;
//        }
//        //开头
//        if (i == 0) {
//            groupExpr.append("&(").append(gStr);
//        }
//        //结尾
//        else if (i == size - 1) {
//            if (rule.getDprRuleRelation().equals(DprRuleRelationEnum.DPR_RULE_RELATION_OR.name())) {
//                groupExpr.append("|").append(gStr).append(")");
//            } else if (rule.getDprRuleRelation().equals(DprRuleRelationEnum.DPR_RULE_RELATION_AND.name())) {
//                groupExpr.append("&").append(gStr).append(")");
//            } else {
//                DataPermissionRuleServiceUtil.throwRuntimeException("非法的DprRuleRelation 规则关系，请尽快联系管理员。：", rule);
//            }
//        }
//        //中间
//        else {
//            if (rule.getDprRuleRelation().equals(DprRuleRelationEnum.DPR_RULE_RELATION_OR.name())) {
//                groupExpr.append("|").append(gStr);
//            } else if (rule.getDprRuleRelation().equals(DprRuleRelationEnum.DPR_RULE_RELATION_AND.name())) {
//                groupExpr.append("&").append(gStr);
//            } else {
//                DataPermissionRuleServiceUtil.throwRuntimeException("非法的DprRuleRelation 规则关系，请尽快联系管理员。：", rule);
//            }
//        }
//    }
//
//
//    /**
//     * 根据请求的path路径  比对当前用户全部的api数据权限配置。 找到对应的api数据权限配置规则组和规则信息并返回
//     *
//     * @param pathObj 路径传参时，路径参数。 通前端规则配置的路径传参占位符： {0} {1} {3}
//     * @return 找到对应的api数据权限配置规则组和规则信息并返回
//     */
//    private List<SysDprRoleApiRuleGroupDTO> apiPathRoleApiRuleGroupDtoHandle(String[] pathObj) {
//        HttpServletRequest request = HttpServletUtil.currentRequest();
//        if (request != null) {
//            String requestUrl = request.getRequestURL().toString();
//            //重点方法：获取当前用户的角色数据权限信息( app api 规则组，规则 )
//            var roelDprDto = getUserRoleDpr();
//            var servletPath = request.getServletPath();
//            var getMethod = request.getMethod();
//            //过滤，找到对应API的数据权限。  如果找不到将不会触发数据权限
//            var startDto = roelDprDto.stream().filter(dto ->
//                    DataPermissionRuleServiceUtil.filterApiUrl(dto, getMethod, servletPath, pathObj)).collect(Collectors.toList());
//
//            if (startDto.isEmpty()) {
//                log.error("数据权限接口，当前API没有配置数据权限规则，请开发人员核对，本次将全量查询。{},{}", requestUrl, roelDprDto);
//            }
//            return startDto;
//        } else {
//            log.error("数据权限接口，无法获取HttpServletRequest，请确认是否HTTP请求入口。");
//            return ListUtil.empty();
//        }
//    }
//
//
//}
