/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.core.security.util;

import com.elitescloud.boot.datasecurity.dataauth.AuthScope;
import com.elitescloud.cloudt.authorization.core.SecurityContextUtil;
import com.elitescloud.cloudt.common.base.QBaseModel;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.PathMetadata;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Deprecated(forRemoval=true, since="3.2.0")
public class DataAuthJpaUtil {
    private static final String ROUTE_KEY = "RouteKey";
    private static boolean dataPermissionEnable = false;

    private DataAuthJpaUtil() {
    }

    public static <T> void dataAuthJpaFilter(JPAQuery<T> query, PathMetadata metadata) {
        DataAuthJpaUtil.dataAuthFilter(query, metadata, null);
    }

    public static <T> void dataAuthJpaFilter(JPAQuery<T> query, PathMetadata metadata, int threshold) {
        DataAuthJpaUtil.dataAuthFilter(query, metadata, threshold);
    }

    private static <T> void dataAuthFilter(JPAQuery<T> query, PathMetadata metadata, Integer threshold) {
        String route;
        QBaseModel qBaseModel;
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        Predicate predicate = DataAuthJpaUtil.preCheck(user, qBaseModel = new QBaseModel(metadata), route = DataAuthJpaUtil.getRequestSysDataRoute());
        if (predicate != null) {
            query.where(predicate);
            return;
        }
        AuthScope authScope = DataAuthJpaUtil.sysDataRoleOperation(user, route, true);
        DataAuthJpaUtil.buildCodePathPredicate(query, qBaseModel, user, authScope, threshold);
    }

    public static Predicate dataAuthJpaPredicate(PathMetadata metadata) {
        String route;
        QBaseModel qBaseModel;
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        Predicate predicate = DataAuthJpaUtil.preCheck(user, qBaseModel = new QBaseModel(metadata), route = DataAuthJpaUtil.getRequestSysDataRoute());
        if (predicate != null) {
            return predicate;
        }
        return null;
    }

    private static Predicate preCheck(GeneralUserDetails user, QBaseModel qBaseModel, String route) {
        if (!dataPermissionEnable) {
            return Expressions.booleanTemplate((String)"1=1", (Object[])new Object[0]);
        }
        if (user == null || user.getUser() == null) {
            return Expressions.booleanTemplate((String)"1=1", (Object[])new Object[0]);
        }
        if (user.isSystemAdmin() || user.isTenantAdmin()) {
            return Expressions.booleanTemplate((String)"1=1", (Object[])new Object[0]);
        }
        AuthScope authScope = DataAuthJpaUtil.sysDataRoleOperation(user, route, false);
        return DataAuthJpaUtil.buildIdInPredicate(qBaseModel, user, authScope);
    }

    private static <T> void buildCodePathPredicate(JPAQuery<T> query, QBaseModel qBaseModel, GeneralUserDetails user, AuthScope authScope, Integer threshold) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        HashSet<Long> buIds = new HashSet<Long>();
        HashSet<Long> empIds = new HashSet<Long>();
        if (CollectionUtils.isNotEmpty(authScope.getBuIds())) {
            buIds.addAll(authScope.getBuIds());
        }
        if (CollectionUtils.isNotEmpty(authScope.getCustomizedBuIds())) {
            buIds.addAll(authScope.getCustomizedBuIds());
        }
        if (CollectionUtils.isNotEmpty(authScope.getChildBuIds()) && CollectionUtils.isNotEmpty(authScope.getBuCodePath()) && (threshold == null || buIds.size() + authScope.getChildBuIds().size() <= threshold)) {
            buIds.addAll(authScope.getChildBuIds());
        }
        if (CollectionUtils.isNotEmpty(buIds)) {
            predicates.add(qBaseModel.secBuId.in(buIds));
        }
        if (CollectionUtils.isNotEmpty(authScope.getEmpIds())) {
            empIds.addAll(authScope.getEmpIds());
        }
        if (CollectionUtils.isNotEmpty(authScope.getCustomizedEmpIds())) {
            empIds.addAll(authScope.getCustomizedEmpIds());
        }
        if (CollectionUtils.isNotEmpty(authScope.getChildEmpIds()) && CollectionUtils.isNotEmpty(authScope.getEmpCodePath()) && (threshold == null || empIds.size() + authScope.getChildEmpIds().size() <= threshold)) {
            empIds.addAll(authScope.getChildEmpIds());
        }
        if (CollectionUtils.isNotEmpty(empIds)) {
            predicates.add(qBaseModel.secUserId.in(empIds));
        }
        if (CollectionUtils.isNotEmpty(authScope.getOuIds())) {
            predicates.add(qBaseModel.secOuId.in(authScope.getOuIds()));
        }
        if (CollectionUtils.isNotEmpty(predicates)) {
            predicates.add(qBaseModel.createUserId.eq((Object)user.getUser().getId()));
            query.where(ExpressionUtils.anyOf(predicates));
        }
    }

    private static Predicate buildIdInPredicate(QBaseModel qBaseModel, GeneralUserDetails user, AuthScope authScope) {
        Set<Long> buIds = authScope.getBuIds();
        Set<Long> userIds = authScope.getEmpIds();
        Set<Long> ouIds = authScope.getOuIds();
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (CollectionUtils.isNotEmpty(buIds)) {
            predicates.add(qBaseModel.secBuId.in(buIds));
        }
        if (CollectionUtils.isNotEmpty(userIds)) {
            predicates.add(qBaseModel.secUserId.in(userIds));
        }
        if (CollectionUtils.isNotEmpty(ouIds)) {
            predicates.add(qBaseModel.secOuId.in(ouIds));
        }
        if (CollectionUtils.isNotEmpty(predicates)) {
            predicates.add(qBaseModel.createUserId.eq((Object)user.getUser().getId()));
            return ExpressionUtils.anyOf(predicates);
        }
        return Expressions.booleanTemplate((String)"1=1", (Object[])new Object[0]);
    }

    private static AuthScope sysDataRoleOperation(GeneralUserDetails user, String route, boolean isCodePath) {
        AuthScope authScope = new AuthScope();
        return authScope;
    }

    private static String getRequestSysDataRoute() {
        if (RequestContextHolder.getRequestAttributes() == null) {
            return null;
        }
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        return request.getHeader(ROUTE_KEY);
    }

    public static void setDataPermissionEnable(boolean dataPermissionEnable) {
        DataAuthJpaUtil.dataPermissionEnable = dataPermissionEnable;
    }
}

