package com.elitescloud.boot.datasecurity.dpr.beansearcher;

import com.elitescloud.cloudt.common.constant.TenantIsolateStrategy;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * BeanSearcher检索器自动追加条件枚举
 * @author : chen.niu
 * @date 2023/1/14 11:53
 */
public enum CloudBeanSearcherEnum {
    /**
     * BeanSearcher检索器自动追加条件枚举
     */
    BS_DEFAULT("BS默认"),
    BS_TENANT("追加租户条件"),
    BS_TENANT_AUTH("追加租户条件与数据权限"),
    BS_AUTH("追加数据权限-暂未实现");

    /**
     * 描述
     */
    private final String description;

    CloudBeanSearcherEnum(String description) {
        this.description = description;
    }

    public String getDescription() {
        return description;
    }

    private static final Map<String, TenantIsolateStrategy> VALUE_MAP = Arrays.stream(TenantIsolateStrategy.values()).collect(Collectors.toMap(TenantIsolateStrategy::name, t -> t, (t1, t2) -> t1));

    public static TenantIsolateStrategy parse(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.get(value);
    }
}
