package com.elitescloud.boot.datasecurity.dpr.service.impl;

import cn.zhxu.bs.util.MapBuilder;
import cn.zhxu.bs.util.MapUtils;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.auth.util.SecurityUtil;
import com.elitescloud.boot.datasecurity.dpr.content.DprRuleValueTypeEnum;
import com.elitescloud.boot.datasecurity.dpr.service.RoleDataPermissionRuleCacheInterface;
import com.elitescloud.boot.datasecurity.dpr.service.RoleDataPermissionRuleService;
import com.elitescloud.boot.datasecurity.dpr.service.util.AnnotationUtil;
import com.elitescloud.boot.datasecurity.dpr.service.util.DataPermissionRuleServiceUtil;
import com.elitescloud.boot.datasecurity.dpr.service.util.RoleDatePermissionColumnUtil;
import com.elitescloud.boot.datasecurity.dpr.service.util.RoleDatePermissionRowUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.cloudt.system.dto.SysDpcRoleApiFieldsDTO;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiDataRuleListQueryDTO;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiRowColumnRuleDTO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.lang.reflect.Field;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 数据权限规则解析接口  需要bean Searcher和jpa分别实现。
 *
 * @author : chen
 * @date 2022-11-24 14:12
 */
@Slf4j
public class RoleDataPermissionRuleServiceImpl implements RoleDataPermissionRuleService {


    private final RoleDataPermissionRuleCacheInterface roleDataPermissionRuleCacheInterface;

    public RoleDataPermissionRuleServiceImpl(RoleDataPermissionRuleCacheInterface roleDataPermissionRuleCacheInterface) {
        this.roleDataPermissionRuleCacheInterface = roleDataPermissionRuleCacheInterface;
    }

    @Override
    public SysDprRoleApiRowColumnRuleDTO getUserRoleDpr() {
        var token = SecurityContextUtil.currentToken();
        if (token == null || "".equals(token)) {
            log.error("数据权限：获取Token为空 ");
            SecurityUtil.throwUnauthorizedException();
            return null;
        }

        var rule = roleDataPermissionRuleCacheInterface.getTokenDprLocalCache(token)
                .orElseGet(() -> roleDataPermissionRuleCacheInterface.getTokenDprRedisCache(token)
                        .orElseGet(() -> roleDataPermissionRuleCacheInterface.roleDataPermissionRuleRpc(token)));
        return rule;
    }



}
