package com.elitescloud.cloudt.core.security.dataauth.metadata;

/**
 * <p>
 * REST API 响应码
 * </p>
 *
 * @author Michael Li
 * @date 2018-11-08
 */
enum DateAuthResultCode {
    /**
     * Http response entity status code, corresponding to HTTP Status Code
     */
    SUCCESS(200, "操作成功"),
    FAIL(18500, "操作失败"),
    INVALID(18400, "没有执行结果"),
    ;

    private final int code;
    private final String msg;

    DateAuthResultCode(final int code, final String msg) {
        this.code = code;
        this.msg = msg;
    }

    public static DateAuthResultCode getCode(int code) {
        DateAuthResultCode[] ecs = DateAuthResultCode.values();
        for (DateAuthResultCode ec : ecs) {
            if (ec.getCode() == code) {
                return ec;
            }
        }
        return SUCCESS;
    }

    public int getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }


}
