package com.elitescloud.cloudt.core.security.dataauth.metadata;

import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.NumberPath;
import lombok.extern.slf4j.Slf4j;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 整形类型的谓词处理
 * </p >
 *
 * @author niu.chen
 * @date 2021-09-07
 */
@Slf4j
public class MateDataJpaTypeLong implements BaseMateDataJpaInterface {

    @Override
    public Predicate mateDataPredicateJpaIn(MateDataPredicateParam mateDataPredicateParam) {
        String fieldValue = mateDataPredicateParam.getFieldValue();
        String[] strArray = DataAuthBusinessJpaUtil.splitFieldValue(fieldValue);
        if (strArray == null || strArray.length == 0) {
            return null;
        }
        List<Long> list = new ArrayList<>();
        for (String s : strArray) {
            list.add(Long.valueOf(s));
        }
        NumberPath<Long> numberPath =
                new JpaMetadataUtil(mateDataPredicateParam.getMetadata())
                        .createNumberField(mateDataPredicateParam.getFieldCode(), Long.class);
        return numberPath.in(list);
    }


    @Override
    public Predicate mateDataPredicateJpaEq(MateDataPredicateParam mateDataPredicateParam) {
        String fieldValue = mateDataPredicateParam.getFieldValue();
        String[] strArray = DataAuthBusinessJpaUtil.splitFieldValue(fieldValue);
        if (strArray == null || strArray.length == 0) {
            return null;
        }
        Long strInt = Long.valueOf(strArray[0]);
        NumberPath<Long> numberPath =
                new JpaMetadataUtil(mateDataPredicateParam.getMetadata())
                        .createNumberField(mateDataPredicateParam.getFieldCode(), Long.class);
        return numberPath.eq(strInt);
    }

    @Override
    @Deprecated
    public Predicate mateDataPredicateJpaContains(MateDataPredicateParam mateDataPredicateParam) {
        log.error("整形暂时不支持Contains");
        return null;
    }

    @Override
    @Deprecated
    public Predicate mateDataPredicateJpaBetween(MateDataPredicateParam mateDataPredicateParam) {
        log.error("整形暂时不支持Between");
        return null;
    }
}
