/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.datasecurity.common;

import cn.hutool.core.lang.Assert;
import cn.zhxu.bs.param.OrderBy;
import cn.zhxu.bs.util.MapBuilder;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class BeanSearcherUtils {
    public static void setParamsOrderBy(List<OrderItem> orders, MapBuilder mapBuilder, OrderBy defaultOrder) {
        Assert.notNull((Object)defaultOrder, (String)"\u9ed8\u8ba4\u6392\u5e8f\u4e0d\u80fd\u7a7a", (Object[])new Object[0]);
        if (orders == null) {
            mapBuilder.orderBy(defaultOrder.getSort(), defaultOrder.getOrder());
            return;
        }
        for (OrderItem orderItem : orders) {
            if (orderItem != null && !orderItem.getColumn().isBlank()) {
                if (orderItem.isAsc()) {
                    mapBuilder.orderBy(orderItem.getColumn()).asc();
                    continue;
                }
                mapBuilder.orderBy(orderItem.getColumn()).desc();
                continue;
            }
            mapBuilder.orderBy(defaultOrder.getSort(), defaultOrder.getOrder());
        }
    }

    public static String generateCondition(String field, String operator, Object value) {
        Object formattedValue;
        if (value instanceof String) {
            formattedValue = "'" + value + "'";
        } else if (value instanceof Number) {
            formattedValue = value.toString();
        } else {
            if ("in".equalsIgnoreCase(operator) && value instanceof Collection) {
                Collection values = (Collection)value;
                if (values.isEmpty()) {
                    return "";
                }
                Object firstValue = values.iterator().next();
                String formattedValue2 = firstValue instanceof String ? values.stream().map(v -> "'" + v + "'").collect(Collectors.joining(",")) : values.stream().map(Object::toString).collect(Collectors.joining(","));
                return "and " + field + " in (" + formattedValue2 + ")";
            }
            formattedValue = value.toString();
        }
        return String.format("and %s %s %s", field, operator, formattedValue);
    }

    public static String convertListNumberToString(List<Long> list) {
        if (list != null && !list.isEmpty()) {
            return list.stream().map(String::valueOf).collect(Collectors.joining(","));
        }
        return "";
    }

    public static String convertListStringToString(List<String> list) {
        if (list != null && !list.isEmpty()) {
            String result = list.stream().map(num -> "'" + num + "'").collect(Collectors.joining(","));
            return result;
        }
        return "";
    }

    public static class Operator {
        public static final String OPERATOR_LIKE = "LIKE";
        public static final String OPERATOR_IN = "IN";
        public static final String OPERATOR_IS = "IS";
        public static final String OPERATOR_IS_NOT = "IS NOT";
        public static final String OPERATOR_BETWEEN = "BETWEEN";
        public static final List<String> OPERATORS = Arrays.asList("<>", "<=", "<", ">=", ">", "=", "!=", "IN");
    }
}

