/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.datasecurity.dpr.service.util;

import cn.hutool.core.util.ArrayUtil;
import cn.zhxu.bs.util.MapBuilder;
import com.elitescloud.boot.datasecurity.dpr.content.DprRuleConditionEnum;
import com.elitescloud.cloudt.system.dto.SysDpcRoleApiFieldsDTO;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiDataRuleListQueryDTO;
import com.google.gson.Gson;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotNull;
import org.springframework.util.StringUtils;

public class DataPermissionRuleServiceUtil {
    public static void throwRuntimeException(String msg, SysDprRoleApiDataRuleListQueryDTO rule) {
        Gson gson = new Gson();
        String data = gson.toJson((Object)rule);
        throw new RuntimeException("\u6570\u636e\u6743\u9650\u5f02\u5e38\uff1a" + msg + data);
    }

    private static String ruleConditionCheckBeanSearcherOp(String dprRuleCondition) {
        if (DprRuleConditionEnum.getValue(dprRuleCondition) != null) {
            return dprRuleCondition;
        }
        throw new RuntimeException("\u975e\u6cd5\u7684\u8fd0\u7b97\u7b26\u8bbe\u7f6e\uff0c\u8bf7\u5c3d\u5feb\u8054\u7cfb\u7ba1\u7406\u5458\u3002\uff1a" + dprRuleCondition);
    }

    public static boolean filterRowAuthApiUrl(@NotNull SysDprRoleApiDataRuleListQueryDTO dto, @NotNull HttpServletRequest request, String[] pathObj) {
        PermissionRuleInfo permissionRuleInfo = new PermissionRuleInfo(dto.getApiPermissionCode(), dto.getApiPermissionPath(), dto.getApiPermissionRequestType());
        return DataPermissionRuleServiceUtil.isMatchApi(permissionRuleInfo, request, pathObj);
    }

    public static boolean filterColumnAuthApiUrl(@NotNull SysDpcRoleApiFieldsDTO dto, @NotNull HttpServletRequest request, String[] pathObj) {
        PermissionRuleInfo permissionRuleInfo = new PermissionRuleInfo(dto.getApiPermissionCode(), dto.getApiPermissionPath(), dto.getApiPermissionRequestType());
        return DataPermissionRuleServiceUtil.isMatchApi(permissionRuleInfo, request, pathObj);
    }

    private static boolean isMatchApi(@NotNull PermissionRuleInfo apiPermission, @NotNull HttpServletRequest request, String[] pathObj) {
        String apiCode = request.getHeader("apiCode");
        if (StringUtils.hasText((String)apiCode)) {
            return Objects.equals(apiPermission.getApiCode(), apiCode);
        }
        if (!request.getMethod().equalsIgnoreCase(apiPermission.getMethod())) {
            return false;
        }
        Object[] pathObjAttribute = (String[])request.getAttribute("pathObj");
        if (!ArrayUtil.isEmpty((Object[])pathObjAttribute)) {
            String apiPathFormat = MessageFormat.format(apiPermission.getPath(), pathObjAttribute);
            return Objects.equals(request.getServletPath(), apiPathFormat);
        }
        if (ArrayUtil.isEmpty((Object[])pathObj)) {
            return Objects.equals(request.getServletPath(), apiPermission.getPath());
        }
        return Objects.equals(request.getServletPath(), pathObj);
    }

    private static boolean isApiPath(String apiPath, String requestUrl, String[] pathObj) {
        if (pathObj == null || pathObj.length == 0) {
            return apiPath.equals(requestUrl);
        }
        String apiPathFormat = MessageFormat.format(apiPath, pathObj);
        return apiPathFormat.equals(requestUrl);
    }

    public static void dprRuleValueTypeMapBuilder(MapBuilder mapBuilder, SysDprRoleApiDataRuleListQueryDTO rule) {
        String valueType = rule.getDprRuleValueType();
        String value = rule.getDprRuleValue();
        String ruleCondition = rule.getDprRuleCondition();
        switch (DprRuleConditionEnum.valueOf(ruleCondition)) {
            case Equal: 
            case EndWith: 
            case StartWith: 
            case Contain: 
            case LessThan: 
            case LessEqual: 
            case GreaterThan: 
            case GreaterEqual: 
            case NotEqual: {
                DataPermissionRuleServiceUtil.mapBuilderFieldValueOne(mapBuilder, value, rule);
                break;
            }
            case Between: 
            case NotBetween: {
                DataPermissionRuleServiceUtil.mapBuilderFieldValueTwo(mapBuilder, value, rule);
                break;
            }
            case InList: 
            case NotIn: {
                DataPermissionRuleServiceUtil.mapBuilderFieldValueMulti(mapBuilder, value, rule);
                break;
            }
            default: {
                DataPermissionRuleServiceUtil.throwRuntimeException("\u975e\u6cd5\u7684\u8fd0\u7b97\u7b26\u8bbe\u7f6e\uff0c\u8bf7\u5c3d\u5feb\u8054\u7cfb\u7ba1\u7406\u5458\u3002\uff1a", rule);
            }
        }
    }

    private static void mapBuilderFieldValueMulti(MapBuilder mapBuilder, String value, SysDprRoleApiDataRuleListQueryDTO rule) {
        String[] values = value.split(",");
        if (values.length == 0) {
            DataPermissionRuleServiceUtil.throwRuntimeException("\u9519\u8bef\u7684\u89c4\u5219\u503c\u53c2\u6570\uff0c\u8bf7\u5c3d\u5feb\u8054\u7cfb\u7ba1\u7406\u5458\u3002\uff1a", rule);
        }
        ArrayList stringList = new ArrayList(values.length);
        Collections.addAll(stringList, values);
        ((MapBuilder)mapBuilder.field(rule.getDprRuleField(), stringList)).op(rule.getDprRuleCondition());
    }

    private static void mapBuilderFieldValueOne(MapBuilder mapBuilder, String value, SysDprRoleApiDataRuleListQueryDTO rule) {
        ((MapBuilder)mapBuilder.field(rule.getDprRuleField(), new Object[]{value})).op(rule.getDprRuleCondition());
    }

    private static void mapBuilderFieldValueTwo(MapBuilder mapBuilder, String value, SysDprRoleApiDataRuleListQueryDTO rule) {
        String[] values = value.split(",");
        if (values.length <= 1) {
            DataPermissionRuleServiceUtil.throwRuntimeException("\u9519\u8bef\u7684\u89c4\u5219\u503c\u53c2\u6570\uff0c\u8bf7\u5c3d\u5feb\u8054\u7cfb\u7ba1\u7406\u5458\u3002\uff1a", rule);
        }
        ArrayList stringList = new ArrayList(values.length);
        Collections.addAll(stringList, values);
        ((MapBuilder)mapBuilder.field(rule.getDprRuleField(), stringList)).op(rule.getDprRuleCondition());
    }

    private static class PermissionRuleInfo {
        private String apiCode;
        private String path;
        private String method;

        public PermissionRuleInfo(String apiCode, String path, String method) {
            this.apiCode = apiCode;
            this.path = path;
            this.method = method;
        }

        public String getApiCode() {
            return this.apiCode;
        }

        public String getPath() {
            return this.path;
        }

        public String getMethod() {
            return this.method;
        }
    }
}

