/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.datasecurity.jpa.strategy;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.datasecurity.dpr.content.DprRuleRelationEnum;
import com.elitescloud.boot.datasecurity.dpr.service.RoleDataPermissionRuleService;
import com.elitescloud.boot.datasecurity.dpr.service.util.RoleDatePermissionColumnUtil;
import com.elitescloud.boot.datasecurity.jpa.strategy.RuleStrategyManager;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiDataRuleListQueryDTO;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiRowColumnRuleDTO;
import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.PathBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoleRuleJpaService {
    private static final Logger log = LoggerFactory.getLogger(RoleRuleJpaService.class);
    private final RoleDataPermissionRuleService roleDataPermissionRuleService;

    public RoleRuleJpaService(RoleDataPermissionRuleService roleDataPermissionRuleService) {
        this.roleDataPermissionRuleService = roleDataPermissionRuleService;
    }

    public SysDprRoleApiRowColumnRuleDTO getUserRoleDpr() {
        return this.roleDataPermissionRuleService.getUserRoleDpr();
    }

    public Predicate getUserRoleApiMenusAuthJpaPredicate(Class entityClass, String alias) {
        Predicate predicate = this.getUserRoleApiMenusAuthJpaPredicate(entityClass, alias, null);
        log.info("\u6570\u636e\u6743\u9650\u8fc7\u6ee4\u6761\u4ef6\uff1a{}", (Object)(predicate == null ? null : predicate.toString()));
        return predicate;
    }

    private Predicate getUserRoleApiMenusAuthJpaPredicate(Class entityClass, String alias, String[] ruleFieldName) {
        SysDprRoleApiRowColumnRuleDTO userRoleDpr = this.roleDataPermissionRuleService.getUserRoleDpr();
        if (userRoleDpr == null || CollUtil.isEmpty((Collection)userRoleDpr.getSysDprRoleApiDataRuleListQueryDTO())) {
            log.info("\u6ca1\u6709\u627e\u5230\u5f53\u524d\u7528\u6237\u6570\u636e\u6743\u9650\u914d\u7f6e-\u8df3\u8fc7\u6570\u636e\u6743\u9650");
            return new BooleanBuilder(null);
        }
        List<Object> startDto = RoleDatePermissionColumnUtil.apiPathRoleApiRowsRuleGroupDtoHandle(null, userRoleDpr);
        if (ruleFieldName != null && ruleFieldName.length > 0) {
            startDto = startDto.stream().filter(dpr -> Arrays.asList(ruleFieldName).contains(dpr.getDprRuleField())).collect(Collectors.toList());
        }
        if (CollUtil.isEmpty(startDto)) {
            log.info("\u6ca1\u6709\u627e\u5230\u5f53\u524d\u7528\u6237\u6570\u636e\u6743\u9650\u914d\u7f6e\u5339\u914d\u89c4\u5219-\u8df3\u8fc7\u6570\u636e\u6743\u9650");
            return new BooleanBuilder(null);
        }
        PathBuilder entityPath = new PathBuilder(entityClass, alias);
        BooleanBuilder returnPredicate = new BooleanBuilder();
        ArrayList<Predicate> groupPredicates = new ArrayList<Predicate>();
        if (startDto != null && !startDto.isEmpty()) {
            Map<Long, List<SysDprRoleApiDataRuleListQueryDTO>> groupMap = this.groupByRole(startDto);
            for (Map.Entry<Long, List<SysDprRoleApiDataRuleListQueryDTO>> entry : groupMap.entrySet()) {
                List<SysDprRoleApiDataRuleListQueryDTO> dtoList = entry.getValue();
                BooleanBuilder groupPredicate = new BooleanBuilder();
                for (SysDprRoleApiDataRuleListQueryDTO sysRule : dtoList) {
                    try {
                        Predicate predicateRule = RuleStrategyManager.getPathAutomatically(entityPath, sysRule);
                        if (DprRuleRelationEnum.DPR_RULE_RELATION_AND.name().equals(sysRule.getDprRuleRelation())) {
                            groupPredicate.and(predicateRule);
                            continue;
                        }
                        if (DprRuleRelationEnum.DPR_RULE_RELATION_OR.name().equals(sysRule.getDprRuleRelation())) {
                            groupPredicate.or(predicateRule);
                            continue;
                        }
                        log.error("\u89c4\u5219\u7684\u5173\u7cfb\u5f02\u5e38:{}", (Object)sysRule);
                    }
                    catch (Exception e) {
                        log.error("\u89c4\u5219\u5b57\u6bb5\u5339\u914d\u5f02\u5e38\uff1a", (Throwable)e);
                    }
                }
                if (!groupPredicate.hasValue()) continue;
                groupPredicates.add(groupPredicate.getValue());
            }
            Predicate[] integersArray2 = (Predicate[])groupPredicates.stream().toArray(Predicate[]::new);
            return returnPredicate.andAnyOf(integersArray2);
        }
        return new BooleanBuilder(null);
    }

    public Map<Long, List<SysDprRoleApiDataRuleListQueryDTO>> groupByRole(List<SysDprRoleApiDataRuleListQueryDTO> startDto) {
        return startDto.stream().collect(Collectors.groupingBy(SysDprRoleApiDataRuleListQueryDTO::getRoleId));
    }

    public Predicate getUserRoleApiMenusAuthJpaPredicateMenusCodeEmpty(Class<?> entityClass, String alias) {
        String menuCode = "";
        try {
            menuCode = RoleDatePermissionColumnUtil.verificationMenu();
            if (menuCode == null) {
                log.info("\u6570\u636e\u6743\u9650\u9700\u8981\u83dc\u5355\u7f16\u7801\u5c06\u8df3\u8fc7\u6570\u636e\u6743\u9650\uff0cgetHeader  menuCode=NULL");
                return new BooleanBuilder(null);
            }
            return this.getUserRoleApiMenusAuthJpaPredicate(entityClass, alias);
        }
        catch (Exception e) {
            StringBuffer sb = new StringBuffer();
            sb.append(entityClass.getSimpleName()).append("-").append(menuCode).append("-").append(alias);
            log.error("JPA\u6743\u9650\u5f02\u5e38\uff0c\u5f02\u5e38\u9700\u8981\u5206\u6790\uff0c\u6682\u8df3\u8fc7\u6743\u9650\u529f\u80fd\uff1a" + sb, (Throwable)e);
            return new BooleanBuilder(null);
        }
    }

    public Predicate getUserRoleApiMenusAuthJpaPredicateMenusCodeEmpty(Class<?> entityClass) {
        String menuCode = "";
        try {
            menuCode = RoleDatePermissionColumnUtil.verificationMenu();
            if (menuCode == null) {
                log.info("\u6570\u636e\u6743\u9650\u9700\u8981\u83dc\u5355\u7f16\u7801\u5c06\u8df3\u8fc7\u6570\u636e\u6743\u9650\uff0cgetHeader  menuCode=NULL");
                return new BooleanBuilder(null);
            }
            String classAlias = entityClass.getSimpleName().substring(0, 1).toLowerCase() + entityClass.getSimpleName().substring(1);
            return this.getUserRoleApiMenusAuthJpaPredicate(entityClass, classAlias);
        }
        catch (Exception e) {
            StringBuffer sb = new StringBuffer();
            sb.append(entityClass.getSimpleName()).append("-").append(menuCode).append("-");
            log.error("JPA\u6743\u9650\u5f02\u5e38\uff0c\u5f02\u5e38\u9700\u8981\u5206\u6790\uff0c\u6682\u8df3\u8fc7\u6743\u9650\u529f\u80fd\uff1a" + sb, (Throwable)e);
            return new BooleanBuilder(null);
        }
    }

    public Predicate getUserRoleApiMenusAuthJpaPredicateMenusCodeEmpty(Class<?> entityClass, String alias, String ... ruleFieldName) {
        String menuCode = "";
        try {
            menuCode = RoleDatePermissionColumnUtil.verificationMenu();
            if (menuCode == null) {
                log.info("\u6570\u636e\u6743\u9650\u9700\u8981\u83dc\u5355\u7f16\u7801\u5c06\u8df3\u8fc7\u6570\u636e\u6743\u9650\uff0cgetHeader  menuCode=NULL");
                return new BooleanBuilder(null);
            }
            return this.getUserRoleApiMenusAuthJpaPredicate(entityClass, alias, ruleFieldName);
        }
        catch (Exception e) {
            StringBuffer sb = new StringBuffer();
            sb.append(entityClass.getSimpleName()).append("-").append(menuCode).append("-");
            log.error("JPA\u6743\u9650\u5f02\u5e38\uff0c\u5f02\u5e38\u9700\u8981\u5206\u6790\uff0c\u6682\u8df3\u8fc7\u6743\u9650\u529f\u80fd\uff1a" + sb, (Throwable)e);
            return new BooleanBuilder(null);
        }
    }
}

