package com.elitescloud.boot.datasecurity.dpr.service.util;



import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * <p>ClassName：AnnotationUtil</p >
 * <p>Description：注解工具</p >
 * <p>Author：nc</p >
 * <p>Date：2022/9/29</p >
 * @author chen
 */
public class AnnotationUtil {

    /**
     * 获取本类及其父类的字段属性
     *
     * @param clazz 当前类对象
     * @return 字段数组
     */
    public static Field[] getAllFields(Class<?> clazz) {
        List<Field> fieldList = new ArrayList<>();
        while (clazz != null) {
            fieldList.addAll(new ArrayList<>(Arrays.asList(clazz.getDeclaredFields())));
            clazz = clazz.getSuperclass();
        }
        Field[] fields = new Field[fieldList.size()];
        return fieldList.toArray(fields);
    }

    public static boolean classIsFieldName(Class<?> clazz,String fieldName) {
           var fs=getAllFields(clazz);
           boolean isFieldName=false;
           for (Field f:fs){
               if (f.getName().equals(fieldName)) {
                   isFieldName = true;
                   break;
               }
           }
           return isFieldName;
    }


}