package com.elitescloud.boot.dubbo;

import com.elitescloud.boot.condition.ConditionalOnRpc;
import com.elitescloud.boot.dubbo.config.handler.DubboExceptionTranslate;
import com.elitescloud.boot.exception.CustomExceptionTranslate;
import org.apache.dubbo.config.bootstrap.DubboBootstrap;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;

/**
 * Dubbo自动化配置.
 *
 * @author Kaiser（wang shao）
 * @date 3/17/2023
 */
@ConditionalOnRpc(requiredDubbo = true)
class CloudtDubboAutoConfiguration {

    @Bean
    @ConditionalOnClass(DubboBootstrap.class)
    public CustomExceptionTranslate exceptionTranslateDubbo() {
        return new DubboExceptionTranslate();
    }
}
