package com.elitescloud.boot.excel.common.support;

import com.elitescloud.boot.excel.config.tmpl.DataExportServiceFactory;

import java.io.Serializable;
import java.util.List;

/**
 * 导出数据格式化.
 *
 * @author Kaiser（wang shao）
 * @date 2024/4/19
 */
public interface ExportedDataFormatter {

    /**
     * 格式化数据
     *
     * @param dataExportService 数据导出服务
     * @param dataList          待处理数据列表
     * @param <T>               数据类型
     */
    <T extends Serializable> void format(DataExportServiceFactory.ServiceMetaData dataExportService, List<T> dataList);
}
