package com.elitescloud.boot.excel.config;

import com.alibaba.excel.EasyExcel;
import com.elitescloud.boot.excel.config.tmpl.TmplConfig;
import com.elitescloud.boot.excel.support.ExportExcelServiceImpl;
import com.elitescloud.cloudt.core.service.ExportExcelService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.core.task.TaskExecutor;

/**
 * Cloudt Excel自动化配置.
 *
 * @author Kaiser（wang shao）
 * @date 3/17/2023
 */
@Import({ExcelSwaggerConfig.class, TmplConfig.class})
@ConditionalOnClass(EasyExcel.class)
@ConditionalOnProperty(prefix = ExcelProperties.CONFIG_PREFIX, name = "enabled", havingValue = "true", matchIfMissing = true)
@EnableConfigurationProperties(ExcelProperties.class)
public class CloudtExcelAutoConfiguration {

    @Bean
    @ConditionalOnProperty(prefix = "elitesland.excel.export", name = "enable", havingValue = "true", matchIfMissing = true)
    public ExportExcelService exportExcelService(ExcelProperties exportExcelProperties,
                                                 TaskExecutor taskExecutor) {
        return new ExportExcelServiceImpl(exportExcelProperties.getExport(), taskExecutor);
    }
}
