package com.elitescloud.boot.excel.config;

import com.elitescloud.boot.excel.common.support.ExcelExportProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

/**
 * excel相关配置.
 *
 * @author Kaiser（wang shao）
 * @date 2021/09/18
 */
@ConfigurationProperties(prefix = ExcelProperties.CONFIG_PREFIX)
public class ExcelProperties {
    public static final String CONFIG_PREFIX = "elitesland.excel";

    /**
     * 是否启用
     */
    private Boolean enabled = true;

    /**
     * 导入导出时是否使用反射方法
     */
    private Boolean useReflect = false;

    @NestedConfigurationProperty
    private ExcelExportProperties export = new ExcelExportProperties();

    public Boolean getEnabled() {
        return enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Boolean getUseReflect() {
        return useReflect;
    }

    public void setUseReflect(Boolean useReflect) {
        this.useReflect = useReflect;
    }

    public ExcelExportProperties getExport() {
        return export;
    }

    public void setExport(ExcelExportProperties export) {
        this.export = export;
    }
}
