package com.elitescloud.boot.excel.config.tmpl.converter;

import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import com.elitescloud.boot.excel.common.support.CustomConverter;
import com.elitescloud.boot.util.DatetimeUtil;

import java.time.LocalDateTime;

/**
 * 日期时间转换器.
 *
 * @author Kaiser（wang shao）
 * @date 2024/1/16
 */
class LocalDateTimeConverter implements CustomConverter<LocalDateTime> {

    @Override
    public Class<LocalDateTime> supportJavaTypeKey() {
        return LocalDateTime.class;
    }

    @Override
    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    @Override
    public LocalDateTime convertToJavaData(CellData cellData, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        var strValue = cellData.getDataFormatString();
        return DatetimeUtil.parseLocalDateTime(strValue);
    }

    @Override
    public CellData<String> convertToExcelData(LocalDateTime value, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        var strValue = value == null ? "" : DatetimeUtil.toStr(value);
        return new CellData<>(strValue);
    }
}
