/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.excel.config.tmpl;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.excel.common.DataImport;
import com.elitescloud.boot.exception.BusinessException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DataImportServiceFactory {
    private static final Logger log = LoggerFactory.getLogger(DataImportServiceFactory.class);
    private final Map<String, ServiceMetaData> dataImportMap = new HashMap<String, ServiceMetaData>(64);

    public DataImportServiceFactory(List<DataImport<?>> dataImportList) {
        this.init(dataImportList);
    }

    public boolean isSupport(String tmplCode) {
        return this.dataImportMap.containsKey(tmplCode);
    }

    public ServiceMetaData getDataImportService(String tmplCode) {
        return this.dataImportMap.get(tmplCode);
    }

    private void init(List<DataImport<?>> dataImportList) {
        if (CollUtil.isEmpty(dataImportList)) {
            return;
        }
        for (DataImport<?> dataImport : dataImportList) {
            if (!this.dataImportMap.containsKey(dataImport.getTmplCode())) continue;
            throw new IllegalStateException("\u5b58\u5728\u91cd\u590d\u7684\u6570\u636e\u5bfc\u5165\u670d\u52a1\uff1a" + dataImport.getTmplCode());
        }
        CompletableFuture.runAsync(() -> {
            for (DataImport dataImport : dataImportList) {
                this.dataImportMap.put(dataImport.getTmplCode(), new ServiceMetaData(dataImport));
            }
        }).whenComplete((r, e) -> {
            if (e != null) {
                log.error("\u521d\u59cb\u5316\u6570\u636e\u5bfc\u5165\u670d\u52a1\u5f02\u5e38\uff1a", e);
                return;
            }
            log.info("initialized DataImportService\uff1a{}", (Object)String.join((CharSequence)",", this.dataImportMap.keySet()));
        });
    }

    public static class ServiceMetaData {
        private final String tmplCode;
        private final Object dataImport;
        private final Class<?> dataType;
        private final Method importMethod;

        public <T extends DataImport<R>, R> ServiceMetaData(T dataImport) {
            this.tmplCode = dataImport.getTmplCode();
            this.dataImport = dataImport;
            this.dataType = (Class)((ParameterizedType)dataImport.getClass().getGenericInterfaces()[0]).getActualTypeArguments()[0];
            if (!Serializable.class.isAssignableFrom(this.dataType)) {
                log.error("\u53c2\u6570\u7c7b\u578b\uff1a{}\u672a\u5b9e\u73b0\u5e8f\u5217\u5316\u63a5\u53e3Serializable", (Object)this.dataType.getName());
            }
            try {
                this.importMethod = dataImport.getClass().getMethod("executeImport", List.class, Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("\u672a\u83b7\u53d6\u5230\u5bfc\u5165\u65b9\u6cd5", e);
            }
        }

        public String applyGetTmplCode() {
            return this.tmplCode;
        }

        public Class<?> applyGetDataType() {
            return this.dataType;
        }

        public int applyGetStepSize() {
            Integer stepSize = ((DataImport)this.dataImport).stepSize();
            if (stepSize == null || stepSize < 1 || stepSize > 1000) {
                return 10;
            }
            return stepSize;
        }

        public Set<Integer> applyGetSheetNos() {
            return ((DataImport)this.dataImport).sheetNoList();
        }

        public List<String> applyImport(List<? extends Serializable> dataList, int startRowIndex) {
            try {
                return (List)this.importMethod.invoke(this.dataImport, dataList, startRowIndex);
            }
            catch (Throwable e) {
                throw new BusinessException("\u5bfc\u5165\u6570\u636e\u5f02\u5e38", e);
            }
        }
    }
}

